% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{elbo}
\alias{elbo}
\title{The evidence lower bound}
\usage{
elbo(
  warray,
  lbeta_array,
  cor_inv,
  postmean,
  postvar,
  bias,
  seq,
  mean_bias,
  var_bias,
  mean_seq,
  var_seq,
  ploidy
)
}
\arguments{
\item{warray}{An three-way array. The (i,j,k)th entry is the variational posterior probability
that individual i at SNP j has dosage k - 1. See \code{\link{compute_all_post_prob}}.}

\item{lbeta_array}{A three-way array. The (i,j,k)th entry is the log-density of the betabinomial
for individual i at SNP j and dosage k - 1. See \code{\link{compute_all_log_bb}}.}

\item{cor_inv}{The inverse of the correlation matrix.}

\item{postmean}{A matrix. The (i,j)th entry is the variational posterior mean for individual i
at SNP j.}

\item{postvar}{A matrix. The (i,j)th entry is the variational posterior variance for individual i at SNP j.}

\item{bias}{A vector. The jth entry is the allele bias for SNP j.}

\item{seq}{A vector. The jth entry is the sequencing error rate at SNP j.}

\item{mean_bias}{The prior mean on the log-bias.}

\item{var_bias}{The prior variance on the log-bias.}

\item{mean_seq}{The prior mean on the logit of the sequencing error rate.}

\item{var_seq}{The prior variance on the logit of the sequencing error rate.}

\item{ploidy}{The ploidy of the species.}
}
\value{
A double. The evidence lower-bound that \code{\link{mupdog}}
    maximizes.
}
\description{
The evidence lower bound
}
\author{
David Gerard
}
\keyword{internal}
