% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pref.R
\name{update_pp_f1}
\alias{update_pp_f1}
\title{Function to update the parameters in the preferential pairing F1 model.}
\usage{
update_pp_f1(weight_vec, control)
}
\arguments{
\item{weight_vec}{\code{colSums(wik_mat)} from \code{\link{flexdog}}.
This is the sum of current posterior probabilities of each individual
having genotype k.}

\item{control}{A list of anything else needed to be passed.
E.g. if \code{model = "ash"},
then \code{inner_weights} needs to be passed through \code{control}
(see \code{\link{get_inner_weights}} for how to get this matrix).}
}
\value{
A list with the following elements:
\describe{
\item{\code{p1_pair_weights}}{A list with the mixing weights for the
    bivalent components of parent 1.}
\item{\code{p2_pair_weights}}{A list with the mixing weights for the
    bivalent components of parent 2.}
\item{\code{obj}}{The maximized objective.}
\item{\code{p1geno}}{The estimated genotype for parent 1.}
\item{\code{p2geno}}{The estimated genotype for parent 2.}
\item{\code{pivec}}{The estimated genotype distribution for the
    offspring.}
}
}
\description{
Function to update the parameters in the preferential pairing F1 model.
}
\seealso{
\code{\link{update_dr}}
}
\author{
David Gerard
}
\keyword{internal}
