% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/urq.R
\name{urq}
\alias{urq}
\title{Unconditional Quantile Regression}
\usage{
urq(formula,data,tau=NULL,kernel=NULL)
}
\arguments{
\item{formula}{a formula object, with the response on the left of a ~ operator, and the terms, separated by + operators, on the right.}

\item{data}{a \code{dataframe} in which to interpret the variables named in the formula}

\item{tau}{the quantile(s) to be estimated, this must be a number (or a vector of numbers) strictly between 0 and 1.}

\item{kernel}{a character string giving the smoothing kernel to be used. This must match one of "gaussian", "rectangular", "triangular", "epanechnikov", "biweight", "cosine" or "optcosine", with default "gaussian".}
}
\description{
Returns an object of class \code{urq}. that represents an Unconditional Quantile Regression Fit
}
\details{
This function returns a Recentered Influence Function regression of given quantiles as proposed by Firpo, S., Fortin, N. M., & Lemieux, T. (2009).
}
\examples{
data(engel)
formula = foodexp ~ income
rifreg=urq(formula,data = engel)
}
\references{
Firpo, S., Fortin, N. M., & Lemieux, T. (2009). Unconditional quantile regressions. Econometrica, 77(3), 953-973.
}
\seealso{
\code{\link{density},\link[uqr]{urqCI}}
}

