% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitly_information.R
\name{bitly_IsProDomain}
\alias{bitly_IsProDomain}
\title{Validate given domain for the PRO features}
\usage{
bitly_IsProDomain(domain, showRequestURL = FALSE)
}
\arguments{
\item{domain}{- A short domain. ie: nyti.ms.}

\item{showRequestURL}{- show URL which has been build and requested from server. 
For debug purposes.}
}
\value{
bitly_pro_domain - 0 or 1 designating whether this is a current bitly domain.

domain - an echo back of the request parameter.
}
\description{
Query whether a given domain is a valid bitly pro domain. Keep in mind that bitly 
custom short domains are restricted to less than 15 characters in length.
}
\examples{
\dontrun{ 
bitly_token <- bitly_auth(key = "be03aead58f23bc1aee6e1d7b7a1d99d62f0ede8", secret = "")
bitly_IsProDomain(domain = "nytidsfds.ms") 
bitly_IsProDomain(domain = "nyti.ms", showRequestURL = TRUE) 
}

}
\seealso{
See \url{http://dev.bitly.com/domains.html#v3_bitly_pro_domain}
}

