% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{add_row_to_ternary_df}
\alias{add_row_to_ternary_df}
\title{Add a row to a 3-valued (ternary) \code{data.frame}}
\usage{
add_row_to_ternary_df(
  df,
  values.pos,
  values.neg,
  pos = "first",
  row.name = NULL
)
}
\arguments{
\item{df}{a \code{data.frame} object with values only in the
the 3-element set \{-1,0,1\}. The column names should be node names
(gene, protein names, etc.).}

\item{values.pos}{a character vector whose elements are indicators of a
positive state/condition and will be assigned a value of \emph{1}.
These elements \strong{must be a subset of the column names} of the given \code{df} parameter.
If empty, no values equal to \emph{1} will be added to the new row.}

\item{values.neg}{a character vector whose elements are indicators of a
negative state/condition and will be assigned a value of \emph{-1}.
If empty, no values equal to \emph{-1} will be added to the new row.
These elements \strong{must be a subset of the column names} of the given \code{df} parameter.}

\item{pos}{string. The position where we should put the new row that will be generated.
Two possible values: "first" (default) or "last".}

\item{row.name}{string. The name of the new row that we will added. Default
value: NULL.}
}
\value{
the \code{df} with one extra row, having elements from the \{-1,0,1\}
set depending on values of \code{values.pos} and \code{values.neg} vectors.
}
\description{
Use this function on a \code{data.frame} object (with values only
in the 3-element set \{-1,0,1\} ideally - specifying either a positive,
negative or none/absent condition/state/result about something) and add an
extra \strong{first or last row vector} with zero values, where \emph{1}
and \emph{-1} will be filled when the column names of the given
\code{data.frame} match the values in the \emph{values.pos} or
\emph{values.neg} vector parameters respectively.
}
\examples{
df = data.frame(c(0,-1,0), c(0,1,-1), c(1,0,0))
colnames(df) = c("A","B","C")
df.new = add_row_to_ternary_df(df, values.pos = c("A"), values.neg = c("C"), row.name = "Hello!")

}
