% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/usmap.R
\docType{package}
\name{usmap}
\alias{usmap}
\alias{usmap-package}
\title{usmap: US maps including Alaska and Hawaii}
\description{
It is usually difficult or inconvenient to create US maps that
  include both Alaska and Hawaii in a convenient spot. All map
  data frames produced by this package use the Albers Equal Area
  projection.
}
\section{Map data frames}{

Alaska and Hawaii have been manually moved to a new location so that
their new coordinates place them to the bottom-left corner of
the map. These maps can be accessed by using the \code{\link{usmap}} function.

The function provides the ability to retrieve maps with either
state borders or county borders using the \code{regions} parameter
for convenience.

States (or counties) can be included such that all other states (or counties)
are excluded using the \code{include} parameter.
}

\section{FIPS lookup tools}{

Several functions have been included to lookup the US state or county
pertaining to a FIPS code.

Likewise a reverse lookup can be done where a FIPS code can be used to
retrieve the associated state(s) or county(ies). This can be useful when
preparing data to be merged with the map data frame.
}

\section{Plot US map data}{

A convenience function \code{\link{plot_usmap}} has been included which
takes similar parameters to \code{\link{us_map}} and returns a \pkg{ggplot2}
object. Since the output is a \code{ggplot} object, other layers can be
added such as scales, themes, and labels. Including data in the function call
will color the map according to the values in the data, creating a choropleth.
}

\references{
Rudis, Bob. "Moving The Earth (well, Alaska & Hawaii) With R."
Blog post. Rud.is., 16 Nov. 2014. Web. 10 Aug. 2015.
<\url{https://rud.is/b/2014/11/16/moving-the-earth-well-alaska-hawaii-with-r/}>.
}
\seealso{
Helpful links:
\itemize{
  \item FIPS code information \cr
    \url{https://en.wikipedia.org/wiki/FIPS_county_code}
    \url{https://en.wikipedia.org/wiki/FIPS_state_code}
  \item US Census Shapefiles \cr
    \url{https://www.census.gov/geographies/mapping-files/time-series/geo/tiger-line-file.html}
  \item Map Features \cr
    \url{https://en.wikipedia.org/wiki/Map_projection}
    \url{https://en.wikipedia.org/wiki/Albers_projection}
    \url{https://en.wikipedia.org/wiki/Choropleth}
}
}
\author{
Paolo Di Lorenzo \cr
\itemize{
  \item Email: \email{paolo@dilorenzo.pl}
  \item Website: \url{https://dilorenzo.pl}
  \item Github: \url{https://github.com/pdil/}
}
}
