% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_table.R
\name{build_table.data.frame}
\alias{build_table.data.frame}
\title{Build summary tables from data.frame objects}
\usage{
\method{build_table}{data.frame}(
  .object,
  ...,
  .by,
  .inverse = FALSE,
  .append.stat = TRUE,
  .parametric = FALSE,
  .show.missing = FALSE,
  .show.test = FALSE,
  .na.rm = TRUE,
  .percent.sign = TRUE,
  .digits = 1,
  .p.digits = 4
)
}
\arguments{
\item{.object}{A data.frame.}

\item{...}{One or more unquoted expressions separated by commas representing
columns in the data.frame. May be specified using
\code{\link[tidyselect:select_helpers]{tidyselect helpers}}. If left empty,
all columns are summarized.}

\item{.by}{An unquoted expression. Optional. The data column to stratify the
summary by.}

\item{.inverse}{A logical. Optional. For logical data, report the frequency
of FALSE values instead of the TRUE.}

\item{.append.stat}{A logical. Optionla. Append the type of summary statistic
to the column label.}

\item{.parametric}{A logical. Optional. Use parametric testing.}

\item{.show.missing}{A logical. Optional. Append a column listing the
frequencies of missing data for each row.}

\item{.show.test}{A logical. Optional. Append a column containing the test
each p-value was derived from.}

\item{.na.rm}{A logical. Optional. Ignore NA values when calculating
frequencies for logical and factor data types.}

\item{.percent.sign}{A logical. Optional. Paste a percent symbol after all
reported frequencies.}

\item{.digits}{An integer. Optional. The number of digits to round numbers to.}

\item{.p.digits}{An integer. Optional. The number of p-value digits to report.}
}
\value{
An object of class \code{tbl_df} (tibble) summarizing the provided
object.
}
\description{
Takes a data.frame object and summarizes the columns into a
ready to export, human-readable summary table. Capable of stratifying data
and performing appropriate hypothesis testing.
}
\examples{
# Sample data
df <- data.frame(
  strata = factor(sample(letters[1:3], 1000, replace = TRUE)),
  numeric = sample(1:100, 1000, replace = TRUE),
  numeric2 = sample(1:100, 1000, replace = TRUE),
  factor = factor(sample(1:5, 1000, replace = TRUE)),
  logical = sample(c(TRUE,FALSE), 1000, replace = TRUE)
)

# Summarize all columns
build_table(df, .by = strata)

# Summarize & rename selected columns
build_table(df, Numeric = numeric2, Factor = factor, .by = strata)
}
\seealso{
\code{\link{build_table}}
}
