% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geoms.R
\name{geom_stepconfint}
\alias{geom_stepconfint}
\title{Step function confidence intervals for ggplot2}
\usage{
geom_stepconfint(mapping = NULL, data = NULL, stat = "identity",
  position = "identity", na.rm = FALSE, ...)
}
\arguments{
\item{mapping}{Aesthetic mappings with aes() function. Like geom_ribbon(), you must provide
columns for x, ymin (lower limit), ymax (upper limit).}

\item{data}{The data to be displayed in this layer. Can inherit from ggplot parent.}

\item{stat}{The statistical transformation to use on the data for this layer, as a string.
Defaults to 'identity'.}

\item{position}{Position adjustment, either as a string, or the result of a call to a
position adjustment function.}

\item{na.rm}{If FALSE, the default, missing values are removed with a warning. If TRUE,
missing values are silently removed.}

\item{...}{Optional. All the other miscellaneous ggplot geom_ribbon() arguments.}
}
\description{
Produces a step function confidence interval for survival curves. Essentially
the geom_step() for confidence intervals which ggplot2 elects not to provide.
}
\note{
Adapted from the survminer package <https://github.com/kassambara/survminer>.
}
\examples{
library(survival)
library(broom)
library(ggplot2)

fit <- survfit(Surv(time, status) ~ trt, data = diabetic)

ggplot(
  data = tidy(fit),
  mapping = aes(x = time, y = estimate)
) +
  geom_step(aes(color = strata)) +
  geom_stepconfint(aes(ymin = conf.low, ymax = conf.high, fill = strata), alpha = 0.3) +
  coord_cartesian(c(0, 50)) +
  scale_x_continuous(expand = c(0.02,0)) +
  labs(x = 'Time', y = 'Freedom From Event') +
  scale_color_manual(
    values = c('#d83641', '#1A45A7'),
    name = 'Treatment',
    labels = c('None', 'Laser'),
    aesthetics = c('colour', 'fill')) +
  theme_black()
}
