% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling.R
\name{partition_fold}
\alias{partition_fold}
\title{Create the multi-label dataset from folds}
\usage{
partition_fold(kfold, n, has.validation = FALSE)
}
\arguments{
\item{kfold}{A \code{kFoldPartition} object obtained from use of the method
\link{create_kfold_partition}.}

\item{n}{The number of the fold to separated train and test subsets.}

\item{has.validation}{Logical value that indicate if a validation
dataset will be used. (Defaul: \code{FALSE})}
}
\value{
A list contained train and test mldr dataset:
 \describe{
   \code{train}{The mldr dataset with train examples, that inclue all
     examples except those that are in test and validation samples}
   \code{test}{The mldr dataset with test examples, defined by the
     number of the fold}
   \code{validation}{Optionally, only if \code{has.validation = TRUE}.
     The mldr dataset with validation examples}
 }
}
\description{
This is a simple way to use k-fold cross validation.
}
\examples{
folds <- create_kfold_partition(toyml, 10)

# Using the first partition
dataset <- partition_fold(folds, 1)
names(dataset)
## [1] "train" "test"

# All iterations
for (i in 1:10) {
   dataset <- partition_fold(folds, i)
   #dataset$train
   #dataset$test
}

# Using 3 folds validation
dataset <- partition_fold(folds, 3, TRUE)
# dataset$train, dataset$test, #dataset$validation
}

