% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_mbr.R
\name{utiml_labels_correlation}
\alias{utiml_labels_correlation}
\title{Phi Correlation Coefficient}
\usage{
utiml_labels_correlation(mdata)
}
\arguments{
\item{mdata}{A mldr multi-label dataset}
}
\value{
A matrix with all labels correlation coefficient. The rows and
 columns have the labels and each value are the correlation between the
 labels. The main diagonal have the 1 value that represents the correlation
 of a label with itself.
}
\description{
Calculate all labels phi correlation coefficient. This is a specialized
version of the Pearson product moment correlation coefficient for categorical
variables with two values, also called dichotomous variables. This is also
called of Pearson product moment Correlation Coefficient (PCC)
}
\examples{
## result <- utiml_labels_correlation(toyml)

# Get the phi coefficient between the labels 'y1' and 'y2'
## result['y1', 'y2']

# Get all coefficients of a specific label
## result[4, -4]
}
\references{
Tsoumakas, G., Dimou, A., Spyromitros, E., Mezaris, V., Kompatsiaris, I., &
 Vlahavas, I. (2009). Correlation-based pruning of stacked binary relevance
 models for multi-label learning. In Proceedings of the Workshop on Learning
 from Multi-Label Data (MLD'09) (pp. 22-30).
}
\seealso{
\code{\link[=mbr]{Meta-BR (MBR or 2BR)}}
}
