% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation.R
\name{multilabel_confusion_matrix}
\alias{multilabel_confusion_matrix}
\title{Compute the confusion matrix for a multi-label prediction}
\usage{
multilabel_confusion_matrix(mdata, mlresult)
}
\arguments{
\item{mdata}{A mldr dataset}

\item{mlresult}{A mlresult prediction}
}
\value{
A mlconfmat object that contains:
\describe{
   \item{Z}{The bipartition matrix prediction.}
   \item{Fx}{The score/probability matrix prediction.}
   \item{R}{The ranking matrix prediction.}
   \item{Y}{The expected matrix bipartition.}
   \item{TP}{The True Positive matrix values.}
   \item{FP}{The False Positive matrix values.}
   \item{TN}{The True Negative matrix values.}
   \item{FN}{The False Negative matrix values.}
   \item{Zi}{The total of positive predictions for each instance.}
   \item{Yi}{The total of positive expected for each instance.}
   \item{TPi}{The total of True Positive predictions for each instance.}
   \item{FPi}{The total of False Positive predictions for each instance.}
   \item{TNi}{The total of True Negative predictions for each instance.}
   \item{FNi}{The total False Negative predictions for each instance.}
   \item{Zl}{The total of positive predictions for each label.}
   \item{Yl}{The total of positive expected for each label.}
   \item{TPl}{The total of True Positive predictions for each label.}
   \item{FPl}{The total of False Positive predictions for each label.}
   \item{TNl}{The total of True Negative predictions for each label.}
   \item{FNl}{The total False Negative predictions for each label.}
 }
}
\description{
The multi-label confusion matrix is an object that contains the prediction,
the expected values and also a lot of pre-processed information related with
these data.
}
\examples{
\donttest{
prediction <- predict(br(toyml), toyml)

mlconfmat <- multilabel_confusion_matrix(toyml, prediction)

# Label with the most number of True Positive values
which.max(mlconfmat$TPl)

# Number of wrong predictions for each label
errors <- mlconfmat$FPl + mlconfmat$FNl

# Examples predict with all labels
which(mlconfmat$Zi == toyml$measures$num.labels)

# You can join one or more mlconfmat
part1 <- create_subset(toyml, 1:50)
part2 <- create_subset(toyml, 51:100)
confmatp1 <- multilabel_confusion_matrix(part1, prediction[1:50, ])
confmatp2 <- multilabel_confusion_matrix(part2, prediction[51:100, ])
mlconfmat <- confmatp1 + confmatp2
}
}
\seealso{
Other evaluation: 
\code{\link{cv}()},
\code{\link{multilabel_evaluate}()},
\code{\link{multilabel_measures}()}
}
\concept{evaluation}
