% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_annotation.R
\name{runUTRAnnotation}
\alias{runUTRAnnotation}
\title{Run UTR annotation on a variant file}
\usage{
runUTRAnnotation(
  variantFile,
  annotationResult,
  species,
  ensemblVersion = NULL,
  dataDir = NULL,
  conservationBwFiles = NULL,
  cores = NULL,
  format = "csv",
  mrl_prediction = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{variantFile}{a CSV file with Chr, Pos, Ref, Alt}

\item{annotationResult}{output annotation file}

\item{species}{species, either human or mouse}

\item{ensemblVersion}{(optional) a number specifying which version of Ensembl annotation you'd like to use, by default use the latest version}

\item{dataDir}{(optional) path to the store / extract database information, if not specified will create a folder named as input variant file name with a "db_" prefix}

\item{conservationBwFiles}{(optional) path to a folder which contains one or more conservation bigWig files. If not set, will skip conservation analysis.}

\item{cores}{(optional) number of cores to use for parallel computing. If not specified, use a single core by default.}

\item{format}{(optional) csv or vcf, the default is csv}

\item{mrl_prediction}{(optional) Whether do MRL prediction and check if it increase or decrease. The default is TRUE.}

\item{verbose}{Whether print diagnostic messages. The default is FALSE.}
}
\value{
A CSV file with annotated variants
}
\description{
Run UTR annotation on a variant file to check whether a variant alter any of the feature element in UTRs, return a CSV file with annotated information
}
\examples{
\donttest{
test_variant_file <- system.file("extdata", "variants_sample.csv", package = "utr.annotation")

# run UTR annotation with 1 core and skip getting conservation scores for variant positions
runUTRAnnotation(variantFile = test_variant_file,
                 annotationResult = "annotated_variants_sample.csv",
                 species = "human",
                 ensemblVersion = 93,
                 dataDir = "test_db")
unlink("test_db", recursive = TRUE)
unlink("annotated_variants_sample.csv")
}
\dontrun{
# Download BigWig format conservation track files hg38.phastCons100way.bw and hg38.phyloP100way.bw
# from UCSC Genome Browser to a folder (here we name it folder_store_conservation_bw_files)
Conservation_scores <- "folder_store_conservation_bw_files"
runUTRAnnotation(variantFile = test_variant_file,
                 annotationResult = "annotated_variants_sample.csv",
                 species = "human",
                 ensemblVersion = 93,
                 dataDir = "test_db",
                 cores = 8,
                 conservationBwFiles = Conservation_scores)
}
}
