% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_overall.R
\name{est_overall}
\alias{est_overall}
\title{Estimate overall risk and vaccine efficacy}
\usage{
est_overall(dat, t_0, method = "Cox", risk = TRUE, ve = TRUE)
}
\arguments{
\item{dat}{A data object returned by load_data}

\item{t_0}{Time point of interest}

\item{method}{One of c("KM", "Cox"), corresponding to either a Kaplan-Meier
estimator ("KM") or a marginalized Cox proportional hazards model
("Cox").}

\item{risk}{Boolean. If TRUE, the controlled risk (CR) curve is computed.}

\item{ve}{Boolean. If TRUE, the controlled vaccine efficacy (CVE) curve is
computed.}
}
\value{
A dataframe containing estimates
}
\description{
Estimate overall risk and vaccine efficacy.
}
\examples{
data(hvtn505)
dat <- load_data(time="HIVwk28preunblfu", event="HIVwk28preunbl", vacc="trt",
                 marker="IgG_V2", covariates=c("age","BMI","bhvrisk"),
                 weights="wt", ph2="casecontrol", data=hvtn505)
est_overall(dat=dat, t_0=578, method="KM")
}
