% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\docType{methods}
\name{plot,cellComparison-method}
\alias{plot,cellComparison-method}
\title{Line graph of a cellComparison object.}
\usage{
\S4method{plot}{cellComparison}(x, xlab = "", ylab = "", las = 2,
  cex.axis = 0.8, cex.legend = 0.8, ...)
}
\arguments{
\item{x}{a \code{cellComparison} object.}

\item{xlab}{[\code{character}] label for x axis (default none)}

\item{ylab}{[\code{character}] label for y axis (default none)}

\item{las}{[\code{numeric}] in \code{{0,1,2,3}} determining axis label rotation}

\item{cex.axis}{[\code{numeric}] Magnification with respect to the current
setting of \code{cex} for axis annotation.}

\item{cex.legend}{[\code{numeric}] Magnification with respect to the current
setting of \code{cex} for legend annotation and title.}

\item{...}{Graphical parameters, passed to \code{plot}. See \code{\link[graphics]{par}}.}
}
\description{
Versions of a data set can be compared cell by cell
using \code{\link{cells}}. The result is a \code{cellComparison}
object. This method creates a line-graph, thus suggesting an
that an ordered sequence of data sets have been compared.
See also \code{\link{barplot,cellComparison-method}} for an
unordered version.
}
\seealso{
Other comparing: \code{\link{as.data.frame,cellComparison-method}},
  \code{\link{as.data.frame,validatorComparison-method}},
  \code{\link{barplot,cellComparison-method}},
  \code{\link{barplot,validatorComparison-method}},
  \code{\link{cells}}, \code{\link{compare}},
  \code{\link{match_cells}},
  \code{\link{plot,validatorComparison-method}}
}
\concept{comparing}
