% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/syntax.R
\name{occurs}
\alias{occurs}
\title{Count how often a value of value combination occurs}
\usage{
occurs(...)
}
\arguments{
\item{...}{When used in a validation rule: a bare (unquoted) list of variable names.
When used directly, a comma-separated list of vectors of equal length.}
}
\value{
For each record it indicates how often the value or value 
        combination in the arguments occur.
}
\description{
For each row in a data frame, count how many similar rows there are. The
\code{...} argument is used to specify which variables are taken into
account. Missing values are counted as a unique value.
}
\examples{

# for each element i the sequence (a,b,c,a,c,a) 
# compute how often it occurrs in the sequence.
occurs(c("a","b","c","a","c","a")) 

# for each record in 'iris' how often do the same
# (Sepal.Length, Species) combinations occur?
with(iris, occurs(Sepal.Length, Species))

# in the context of a validation. Check whether
# each individual Species occurs at least 10 times.

rules <- validator(occurs(Species) > 10)
cf <- confront(iris, rules)
summary(cf)

}
