% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbls.r
\docType{package}
\name{ivl_df}
\alias{ivl_df}
\alias{genome_df}
\alias{check_interval}
\alias{check_genome}
\title{Bed-like data.frame requirements for valr functions}
\usage{
check_interval(x)

check_genome(x)
}
\arguments{
\item{x}{A \code{data.frame} or \code{tibble::tibble}}
}
\description{
Required column names for interval dataframes are
\code{chrom}, \code{start} and \code{end}. Internally interval dataframes are
validated using \code{check_interval()}

Required column names for genome dataframes are
\code{chrom} and \code{size}. Internally genome dataframes are
validated using \code{check_genome()}.
}
\examples{
# using tibble
x <- tibble::tribble(
  ~chrom, ~start, ~end,
  "chr1", 1, 50,
  "chr1", 10, 75,
  "chr1", 100, 120
)

check_interval(x)

# using base R data.frame
x <- data.frame(
  chrom = "chr1",
  start = 0,
  end = 100,
  stringsAsFactors = FALSE
)

check_interval(x)

# example genome input

x <- tibble::tribble(
  ~chrom, ~size,
  "chr1", 1e6
)

check_genome(x)

}
