% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed_partition.r
\name{bed_partition}
\alias{bed_partition}
\title{Partition intervals into elemental intervals}
\usage{
bed_partition(x, ...)
}
\arguments{
\item{x}{\link{ivl_df}}

\item{...}{name-value pairs specifying column names and expressions to apply}
}
\value{
\code{\link[=ivl_df]{ivl_df()}}
}
\description{
Convert a set of intervals into elemental intervals that contain each start
and end position in the set.
}
\details{
Summary operations, such as \code{\link[=min]{min()}} or \code{\link[=count]{count()}} can be performed
on elemental intervals by specifying name-value pairs.

This function is useful for calculating summaries across overlapping intervals
without merging the intervals.

input tbls are grouped by \code{chrom} by default, and additional
groups can be added using \code{\link[dplyr:group_by]{dplyr::group_by()}}. For example,
grouping by \code{strand} will constrain analyses to the same strand. To
compare opposing strands across two tbls, strands on the \code{y} tbl can
first be inverted using \code{\link[=flip_strands]{flip_strands()}}.
}
\examples{
x <- tibble::tribble(
  ~chrom, ~start, ~end, ~value, ~strand,
  "chr1", 100, 500, 10, "+",
  "chr1", 200, 400, 20, "-",
  "chr1", 300, 550, 30, "+",
  "chr1", 550, 575, 2, "+",
  "chr1", 800, 900, 5, "+"
)


bed_glyph(bed_partition(x))
bed_glyph(bed_partition(x, value = sum(value)), label = "value")

bed_partition(x)

# compute summary over each elemental interval
bed_partition(x, value = sum(value))

# partition and compute summaries based on group
x <- dplyr::group_by(x, strand)
bed_partition(x, value = sum(value))

# combine values across multiple tibbles
y <- tibble::tribble(
  ~chrom, ~start, ~end, ~value, ~strand,
  "chr1", 10, 500, 100, "+",
  "chr1", 250, 420, 200, "-",
  "chr1", 350, 550, 300, "+",
  "chr1", 550, 555, 20, "+",
  "chr1", 800, 900, 50, "+"
)

x <- dplyr::bind_rows(x, y)
bed_partition(x, value = sum(value))

}
\seealso{
\url{https://bedops.readthedocs.io/en/latest/content/reference/set-operations/bedops.html#partition-p-partition}

Other single set operations: 
\code{\link{bed_cluster}()},
\code{\link{bed_complement}()},
\code{\link{bed_flank}()},
\code{\link{bed_merge}()},
\code{\link{bed_shift}()},
\code{\link{bed_slop}()}
}
\concept{single set operations}
