% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/empirical_comparison.R
\name{compute_F_statistics}
\alias{compute_F_statistics}
\title{compute_F_statistics}
\usage{
compute_F_statistics(
  df,
  utility_columns,
  utility_combinations = NULL,
  weight_column = "VAS",
  weight_range = c(0:100),
  sample_size = nrow(df),
  number_of_samples = 1000,
  variant_fun = .cut_variable,
  breaks = c(0, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100),
  graph_title = "",
  x_axis_title = "",
  y_axis_title = "",
  y_min_value = NULL,
  y_max_value = NULL,
  F_stats_groups = NULL
)
}
\arguments{
\item{df}{A data frame containing the utility and weight columns.}

\item{utility_columns}{A character vector specifying the names of utility columns.}

\item{utility_combinations}{A matrix with two rows indicating the utility columns combinations. Default is all possible combinations of the elements of utility_columns taken 2 at a time.}

\item{weight_column}{A character string specifying the name of the weight column. Default is "VAS".}

\item{weight_range}{A numeric vector specifying the range of weights. Default is c(0:100).}

\item{sample_size}{An integer specifying the sample size for bootstrapping. Default is 1000.}

\item{number_of_samples}{An integer specifying the number of bootstrap samples. Default is 1000.}

\item{variant_fun}{A function to be applied for factorizing the weight column. Default is .cut_variable.}

\item{breaks}{A numeric vector specifying the breaks for the 'cut' method. Default is c(0,10,20,30,40,50,60,70,80,90,100).}

\item{graph_title}{A character string specifying the title of the plot. Default is an empty string.}

\item{x_axis_title}{A character string specifying the title for the x-axis. Default is an empty string.}

\item{y_axis_title}{A character string specifying the title for the y-axis. Default is an empty string.}

\item{y_min_value}{A numeric value specifying the minimum value for the y-axis. Default is NULL.}

\item{y_max_value}{A numeric value specifying the maximum value for the y-axis. Default is NULL.}

\item{F_stats_groups}{An optional data frame of pre-computed group-based F-statistics. Default is NULL.}
}
\value{
A list containing two elements: 'df' which is a data frame of weighted statistics, and 'plot' which is the ggplot object representing the ribbon plot.
}
\description{
This function computes F-statistics for specified utility columns in a data frame.
}
\examples{
\donttest{
  # Define dimension names for EQ-5D-3L and EQ-5D-5L
  dim.names.3L <- c("mobility", "selfcare", "activity", "pain", "anxiety")
  dim.names.5L <- c("mobility5L", "selfcare5L", "activity5L", "pain5L", "anxiety5L")
  # Compute EQ-5D scores using the eq5dsuite package
  cdta$EQ5D3L <- eq5dsuite::eq5d3l(x = cdta,
                                   country = "US", 
                                   dim.names = dim.names.3L)
  cdta$EQ5D5L <- eq5dsuite::eq5d5l(x = cdta, 
                                   country = "US", 
                                   dim.names = dim.names.5L)
  cdta$EQXW <- eq5dsuite::eqxw(x = cdta, 
                               country = "US", 
                               dim.names = dim.names.5L)
  # Define combinations of utility columns for F-statistics calculation
  utility_combinations <- matrix(c("EQ5D5L", "EQ5D3L", "EQ5D5L", "EQXW"), nrow = 2)
  # Compute F-statistics for the utility columns
  result <- compute_F_statistics(df = cdta, 
                                 utility_columns = c("EQ5D3L", "EQ5D5L", "EQXW"), 
                                 utility_combinations = utility_combinations)
  # Plot the results
  print(result$plot)
}
}
