% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConservedWaters.R
\name{ConservedWaterStats}
\alias{ConservedWaterStats}
\title{Conserved Water Statistics}
\usage{
ConservedWaterStats(h2o.cluster, num.h2o.inital, num.pdbs.got.h2o)
}
\arguments{
\item{h2o.cluster}{Conserved water cluster}

\item{num.h2o.inital}{Number of initial waters}

\item{num.pdbs.got.h2o}{Number of PDB structures with waters}
}
\value{
A table with the following information is returned:
\itemize{
\item Number of structures
\item Number of initial waters
\item Number of waters used in the calculations
\item Number of water clusters
\item Average water conservation
\item Number of conserved waters with
\itemize{
\item < 50\% conservation
\item 50 - 69\% conservation
\item 70 - 79\% conservation
\item 80 - 89\% conservation
\item 90 - 99\% conservation
\item 100\% conservation
}
\item Number of pairwise distances evaluated
\item Amount of memory used by the pairwise diatance matrix
\item Pairwise distance calculation time
\item Cluster centroid distance calculation time
}
}
\description{
Calculates the Conserved Water Statistics for
\code{\link[=ConservedWaters]{ConservedWaters()}}
}
\details{
Calculates the statistics for each conserved water analysis
performed by \code{\link[=ConservedWaters]{ConservedWaters()}}. This summary information is useful for
timings information and is written to the Excel workbook.
}
\seealso{
Other "vanddraabe utilities": \code{\link{FreeSASAcheck}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
