% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChainsOfInterest.R
\name{RetainChainsOfInterest}
\alias{RetainChainsOfInterest}
\title{Retain Chains Of Interest}
\usage{
RetainChainsOfInterest(atoms.oi, chains.explore, chains.oi)
}
\arguments{
\item{atoms.oi}{\code{data.frame} containing the PDB of the protein}

\item{chains.explore}{String of chains to explore}

\item{chains.oi}{String from the \code{\link[=DetermineChainsOfInterest]{DetermineChainsOfInterest()}} function
indicating if \code{"first"}, \code{"all"}, or a \code{"user"} defined set of chains
should be used. \emph{\strong{NOTE}}: \code{"first"} is alphabetically first. Thus if the
order within the original PDB file is \code{L} and then \code{H}, this function will
return \code{H} because it is alphebetically first.}
}
\value{
\code{data.frame} of the protein atoms retained based on the indicated
chains of interest
}
\description{
Retain chains of interest based on user input parameters
}
\details{
Using the user provided chains of interest, indicate the PDB chains
to retain.

\emph{\strong{NOTE}}: This is a \emph{\strong{non-public}} function and is \emph{\strong{NOT}} available
for general use. Please contact the author if you believe this function
should be available for general use.
}
\examples{
  \dontrun{
  RetainChainsOfInterest(PDB.4dfr$atom, "B", "user")
  RetainChainsOfInterest(PDB.1hai$atom, c("H", "L"), "user")
  RetainChainsOfInterest(PDB.4dfr$atom, "A", "first")
  }

}
\seealso{
Other utilities: \code{\link{ConservationSet}},
  \code{\link{DetermineChainsOfInterest}},
  \code{\link{ExtractFileTimeStamp}},
  \code{\link{ExtractPDBids}}, \code{\link{FileTimeStamp}},
  \code{\link{HasXWaters}}, \code{\link{Nearby}},
  \code{\link{ProtHetWatIndices}},
  \code{\link{RescaleValues}},
  \code{\link{ReturnPDBfullPath}},
  \code{\link{StandardizeAsparticAcidNames}},
  \code{\link{StandardizeCysteineNames}},
  \code{\link{StandardizeGlutamicAcidNames}},
  \code{\link{StandardizeHistidineNames}},
  \code{\link{StandardizeLysineNames}},
  \code{\link{TimeSpan}}, \code{\link{UniqueAtomHashes}},
  \code{\link{aaStandardizeNames}},
  \code{\link{getAtomTypeCounts}},
  \code{\link{getResTypeCounts}}, \code{\link{res2xyz}},
  \code{\link{resAtomType2AtomClass}},
  \code{\link{write.basic.pdb}},
  \code{\link{write.conservedWaters.pdb}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
