% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HydrophilicityEvaluation.R
\name{calcAtomHydrationEstimate}
\alias{calcAtomHydrationEstimate}
\title{Estimated Atomic Hydration Fraction}
\usage{
calcAtomHydrationEstimate(df.AtomHydroTEMP, AT.hydratFract)
}
\arguments{
\item{df.AtomHydroTEMP}{The newly calculated (determined) atomic
hydrophilicity values}

\item{AT.hydratFract}{The \code{AtomTypeClasses.hydratFract} variable calculated
with the \code{\link[=HydrophilicityEvaluation]{HydrophilicityEvaluation()}} function; the mean hydration fraction
for the AtomTypes}
}
\value{
This function returns the hydration estimate values in a string to the variable
\code{AT.hydratFract.estimates} and are included in the \code{HydrophilicityTable}
results of \code{\link[=HydrophilicityEvaluation]{HydrophilicityEvaluation()}}.
}
\description{
Calculates the estimated atomic hydration fraction for an atom
with unknown surface exposure.
}
\details{
This function is called within \code{\link[=HydrophilicityEvaluation]{HydrophilicityEvaluation()}} to
calculate the estimated hydration of an atom with unknown surface exposure.

\deqn{(num surface exposures)/(num atom occurrences) * atom class
  hydration fraction}

\emph{\strong{NOTE}}: This is a non-public function.
}
\examples{
 \dontrun{
  calcAtomHydrationEstimate(df.AtomHydroTEMP, AT.hydratFract)
 }

}
\references{
Leslie A Kuhn, Craig A Swanson, Michael E Pique, John A Tainer,
and Elizabeth D Getzof. Atomic and Residue Hydrophilicity in the Context of
Folded Protein Structures. \emph{PROTEINS: Structure, Function, and
Genetics}, 1995, \strong{23} (\emph{4}), pp 536-547.
\href{http://doi.org/10.1002/prot.340230408}{DOI: 10.1002/prot.340230408}
\href{http://www.ncbi.nlm.nih.gov/pubmed/8749849}{PMID: 8749849}
}
\seealso{
Other "Hydrophilicity Evaluation" "Bound Water Environment": \code{\link{HydrophilicityEvaluation}},
  \code{\link{calcAtomClassHydrophilicity}},
  \code{\link{getProtAtomsNearWater}},
  \code{\link{getResidueData}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
\concept{"Hydrophilicity Evaluation" "Bound Water Environment"}
