% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Constants.R
\docType{data}
\name{names.res.AtomTypes}
\alias{names.res.AtomTypes}
\title{Residue and AtomType Names}
\format{An object of class \code{character} of length 167.}
\usage{
names.res.AtomTypes
}
\description{
Residue and AtomType names based on PDB atom naming conventions.
}
\details{
The 167 residue-atomtype names based on the 20 naturally occurring
amino acids.
}
\examples{
  names.res.AtomTypes
  # [1] "ALA C"   "ALA CA"  "ALA CB"  "ALA N"   "ALA O"   "ARG C"   "ARG CA"
  #     "ARG CB"  "ARG CD"  "ARG CG"  "ARG CZ"  "ARG N"   "ARG NE"  "ARG NH1"
  #     "ARG NH2" "ARG O"   "ASN C"   "ASN CA"  "ASN CB"  "ASN CG"  "ASN N"
  #     "ASN ND2" "ASN O"   "ASN OD1" "ASP C"   "ASP CA"  "ASP CB"  "ASP CG"
  #     "ASP N"   "ASP O"   "ASP OD1" "ASP OD2" "CYS C"   "CYS CA"  "CYS CB"
  #     "CYS N"   "CYS O"   "CYS SG"  "GLN C"   "GLN CA"  "GLN CB"  "GLN CD"
  #     "GLN CG"  "GLN N"   "GLN NE2" "GLN O"   "GLN OE1" "GLU C"   "GLU CA"
  #     "GLU CB"  "GLU CD"  "GLU CG"  "GLU N"   "GLU O"   "GLU OE1" "GLU OE2"
  #     "GLY C"   "GLY CA"  "GLY N"   "GLY O"   "HIS C"   "HIS CA"  "HIS CB"
  #     "HIS CD2" "HIS CE1" "HIS CG"  "HIS N"   "HIS ND1" "HIS NE2" "HIS O"
  #     "ILE C"   "ILE CA"  "ILE CB"  "ILE CD1" "ILE CG1" "ILE CG2" "ILE N"
  #     "ILE O"   "LEU C"   "LEU CA"  "LEU CB"  "LEU CD1" "LEU CD2" "LEU CG"
  #     "LEU N"   "LEU O"   "LYS C"   "LYS CA"  "LYS CB"  "LYS CD"  "LYS CE"
  #     "LYS CG"  "LYS N"   "LYS NZ"  "LYS O"   "MET C"   "MET CA"  "MET CB"
  #     "MET CE"  "MET CG"  "MET N"   "MET O"   "MET SD"  "PHE C"   "PHE CA"
  #     "PHE CB"  "PHE CD1" "PHE CD2" "PHE CE1" "PHE CE2" "PHE CG"  "PHE CZ"
  #     "PHE N"   "PHE O"   "PRO C"   "PRO CA"  "PRO CB"  "PRO CD"  "PRO CG"
  #     "PRO N"   "PRO O"   "SER C"   "SER CA"  "SER CB"  "SER N"   "SER O"
  #     "SER OG"  "THR C"   "THR CA"  "THR CB"  "THR CG2" "THR N"   "THR O"
  #     "THR OG1" "TRP C"   "TRP CA"  "TRP CB"  "TRP CD1" "TRP CD2" "TRP CE2"
  #     "TRP CE3" "TRP CG"  "TRP CH2" "TRP CZ2" "TRP CZ3" "TRP N"   "TRP NE1"
  #     "TRP O"   "TYR C"   "TYR CA"  "TYR CB"  "TYR CD1" "TYR CD2" "TYR CE1"
  #     "TYR CE2" "TYR CG"  "TYR CZ"  "TYR N"   "TYR O"   "TYR OH"  "VAL C"
  #     "VAL CA"  "VAL CB"  "VAL CG1" "VAL CG2" "VAL N"   "VAL O"

}
\seealso{
Other constants: \code{\link{names.backbone.atoms}},
  \code{\link{names.polar.atoms}},
  \code{\link{names.resATs.carb.sulf}},
  \code{\link{names.resATs.nitro.neut}},
  \code{\link{names.resATs.nitro.pos}},
  \code{\link{names.resATs.oxy.neg}},
  \code{\link{names.resATs.oxy.neut}},
  \code{\link{names.residues}},
  \code{\link{names.sidechain.atoms}},
  \code{\link{names.waters}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
\concept{constants}
\keyword{datasets}
