% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{methods}
\name{import_vardef}
\alias{import_vardef}
\alias{import_vardef,data.frame-method}
\title{Import definition of variables}
\usage{
import_vardef(vardf, col_replacement)

\S4method{import_vardef}{data.frame}(vardf, col_replacement)
}
\arguments{
\item{vardf}{A \code{data.frame} that represents a \link[=variable_definition_table]{definition of variables table}.}

\item{col_replacement}{Replacement for the columns}
}
\value{
Return a \code{\link[=DatabaseDef-class]{DatabaseDef}} object.
}
\description{
Import definition of several variables and create a \code{\link[=DatabaseDef-class]{DatabaseDef}} object.
}
\details{
The \code{col_replacement} parameter by default are :
\code{c(rname = "rname",
        varlabel = "varlabel",
        description = "description",
        type = "type",
        commentary = "commentary",
        flevel = "flevel",
        flabel = "flabel")}.
It is possible to overwrite by passing \code{c(key = "value")} in the \code{colnames} parameter.
}
\section{Methods (by class)}{
\itemize{
\item \code{data.frame}: 
}}
\examples{
# create a simple definition of variables table in a data.frame
testdf <- read.table(header = TRUE, stringsAsFactors=FALSE,
  text="
  rname  varlabel  description  type  flevel1  name1  flevel2  name2  flevel3  name3
  id        Identification  'Unique ID'  integer NA NA NA NA NA NA
  age       'Age of patient' NA integer NA NA NA NA NA NA
  city      'City'  'City where live actually' factor 1 Strasbourg 2 Paris 3 London
  weight    'Weight' 'Weight at the beginning of the study' numeric NA NA NA NA NA NA
  ")
# create the DatabaseDef object
import_vardef(testdf)

# When the headers are not standard, it's possible to pass a
# replacement dictionnary
names(testdf) <- c("variable", "etiquette", "description",
                   "type",  "code1",  "modalite1",  "code2",  "modalite2",
                   "code3",  "modalite3")
head(testdf)
import_vardef(testdf,
              col_replacement =  c("rname" = "variable",
                                   "varlabel"    = "etiquette",
                                   "flevel"    = "code",
                                   "flabel"     = "modalite")
)
}
\seealso{
To create a \link[=variable_definition_table]{definition of variables table} from a database, use \code{/link{descvars_skeleton}}.
}

