% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vault_client_auth_approle.R
\name{vault_client_auth_approle}
\alias{vault_client_auth_approle}
\title{Vault AppRole Authentication Configuration}
\description{
Interact with vault's AppRole authentication backend.  For more
details about this, see the vault documentation at
\url{https://www.vaultproject.io/docs/auth/approle.html}
}
\section{Methods}{


\describe{
\item{\code{custom_mount}}{
  Set up a \code{vault_client_auth_approle} object at a custom mount. For example, suppose you mounted the \code{approle} authentication backend at \code{/approle-dev} you might use \code{ar <- vault$auth$approle2$custom_mount("/approle-dev")} - this pattern is repeated for other secret and authentication backends.
  \cr\emph{Usage:}\preformatted{custom_mount(mount)}

  \emph{Arguments:}
  \itemize{
    \item{\code{mount}:   String, indicating the path that the engine is mounted at.
    }
  }
}
\item{\code{role_list}}{
  This endpoint returns a list the existing AppRoles in the method.
  \cr\emph{Usage:}\preformatted{role_list()}
}
\item{\code{role_write}}{
  Creates a new AppRole or updates an existing AppRole. This endpoint supports both create and update capabilities. There can be one or more constraints enabled on the role. It is required to have at least one of them enabled while creating or updating a role.
  \cr\emph{Usage:}\preformatted{role_write(role_name, bind_secret_id = NULL, secret_id_bound_cidrs = NULL,
      token_bound_cidrs = NULL, policies = NULL, secret_id_num_uses = NULL,
      secret_id_ttl = NULL, token_num_uses = NULL, token_ttl = NULL,
      token_max_ttl = NULL, period = NULL, enable_local_secret_ids = NULL,
      token_type = NULL)}

  \emph{Arguments:}
  \itemize{
    \item{\code{role_name}:   Name of the AppRole
    }

    \item{\code{bind_secret_id}:   Require secret_id to be presented when logging in using this AppRole (boolean, default is \code{TRUE}).
    }

    \item{\code{secret_id_bound_cidrs}:   Character vector of CIDR blocks; if set, specifies blocks of IP addresses which can perform the login operation.
    }

    \item{\code{token_bound_cidrs}:   Character vector of if set, specifies blocks of IP addresses which can use the auth tokens generated by this role.
    }

    \item{\code{policies}:   Character vector of policies set on tokens issued via this AppRole.
    }

    \item{\code{secret_id_num_uses}:   Number of times any particular SecretID can be used to fetch a token from this AppRole, after which the SecretID will expire. A value of zero will allow unlimited uses.
    }

    \item{\code{secret_id_ttl}:   Duration, after which any SecretID expires.
    }

    \item{\code{token_num_uses}:   Number of times issued tokens can be used. A value of 0 means unlimited uses.
    }

    \item{\code{token_ttl}:   Duration to set as the TTL for issued tokens and at renewal time.
    }

    \item{\code{token_max_ttl}:   Duration, after which the issued token can no longer be renewed.
    }

    \item{\code{period}:   A duration; when set, the token generated using this AppRole is a periodic token; so long as it is renewed it never expires, but the TTL set on the token at each renewal is fixed to the value specified here. If this value is modified, the token will pick up the new value at its next renewal.
    }

    \item{\code{enable_local_secret_ids}:   Boolean, if \code{TRUE}, then the secret IDs generated using this role will be cluster local. This can only be set during role creation and once set, it can't be reset later.
    }

    \item{\code{token_type}:   The type of token that should be generated via this role. Can be \code{service}, \code{batch}, or \code{default} to use the mount's default (which unless changed will be service tokens).
    }
  }
}
\item{\code{role_read}}{
  Reads the properties of an existing AppRole.
  \cr\emph{Usage:}\preformatted{role_read(role_name)}

  \emph{Arguments:}
  \itemize{
    \item{\code{role_name}:   Name of the AppRole
    }
  }
}
\item{\code{role_delete}}{
  Deletes an existing AppRole from the method.
  \cr\emph{Usage:}\preformatted{role_delete(role_name)}

  \emph{Arguments:}
  \itemize{
    \item{\code{role_name}:   Name of the AppRole to delete
    }
  }
}
\item{\code{role_id_read}}{
  Reads the RoleID of an existing AppRole.
  \cr\emph{Usage:}\preformatted{role_id_read(role_name)}

  \emph{Arguments:}
  \itemize{
    \item{\code{role_name}:   Name of the AppRole
    }
  }
}
\item{\code{role_id_write}}{
  Updates the RoleID of an existing AppRole to a custom value.
  \cr\emph{Usage:}\preformatted{role_id_write(role_name, role_id)}

  \emph{Arguments:}
  \itemize{
    \item{\code{role_name}:   Name of the AppRole (string)
    }

    \item{\code{role_id}:   Value to be set as RoleID (string)
    }
  }
}
\item{\code{secret_id_generate}}{
  Generates and issues a new SecretID on an existing AppRole. Similar to tokens, the response will also contain a \code{secret_id_accessor} value which can be used to read the properties of the SecretID without divulging the SecretID itself, and also to delete the SecretID from the AppRole.
  \cr\emph{Usage:}\preformatted{secret_id_generate(role_name, metadata = NULL, cidr_list = NULL, token_bound_cidrs = NULL)}

  \emph{Arguments:}
  \itemize{
    \item{\code{role_name}:   Name of the AppRole.
    }

    \item{\code{metadata}:   Metadata to be tied to the SecretID. This should be a named list of key-value pairs. This metadata will be set on tokens issued with this SecretID, and is logged in audit logs in plaintext.
    }

    \item{\code{cidr_list}:   Character vector CIDR blocks enforcing secret IDs to be used from specific set of IP addresses. If \code{bound_cidr_list} is set on the role, then the list of CIDR blocks listed here should be a subset of the CIDR blocks listed on the role.
    }

    \item{\code{token_bound_cidrs}:   Character vector of CIDR blocks; if set, specifies blocks of IP addresses which can use the auth tokens generated by this SecretID. Overrides any role-set value but must be a subset.
    }
  }
}
\item{\code{secret_id_list}}{
  Lists the accessors of all the SecretIDs issued against the AppRole. This includes the accessors for "custom" SecretIDs as well.
  \cr\emph{Usage:}\preformatted{secret_id_list(role_name)}

  \emph{Arguments:}
  \itemize{
    \item{\code{role_name}:   Name of the AppRole
    }
  }
}
\item{\code{secret_id_read}}{
  Reads out the properties of a SecretID.
  \cr\emph{Usage:}\preformatted{secret_id_read(role_name, secret_id, accessor = FALSE)}

  \emph{Arguments:}
  \itemize{
    \item{\code{role_name}:   Name of the AppRole
    }

    \item{\code{secret_id}:   Secret ID attached to the role
    }

    \item{\code{accessor}:   Logical, if \code{TRUE}, treat \code{secret_id} as an accessor rather than a secret id.
    }
  }
}
\item{\code{secret_id_delete}}{
  Delete an AppRole secret ID
  \cr\emph{Usage:}\preformatted{secret_id_delete(role_name, secret_id, accessor = FALSE)}

  \emph{Arguments:}
  \itemize{
    \item{\code{role_name}:   Name of the AppRole
    }

    \item{\code{secret_id}:   Secret ID attached to the role
    }

    \item{\code{accessor}:   Logical, if \code{TRUE}, treat \code{secret_id} as an accessor rather than a secret id.
    }
  }
}
\item{\code{login}}{
  Log into the vault using AppRole authentication.  Normally you would not call this directly but instead use \code{$login} with \code{method = "approle"} and proving the \code{role_id} and \code{secret_id} arguments.  This function returns a vault token but does not set it as the client token.
  \cr\emph{Usage:}\preformatted{login(role_id, secret_id)}

  \emph{Arguments:}
  \itemize{
    \item{\code{role_id}:   RoleID of the AppRole
    }

    \item{\code{secret_id}:   SecretID belonging to AppRole
    }
  }
}
}
}

\examples{

vaultr::vault_client(addr = "https://localhost:8200")$auth$approle
}
