% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcfR2hapmap.R
\name{vcfR2hapmap}
\alias{vcfR2hapmap}
\title{Convert a vcfR object to hapmap}
\usage{
vcfR2hapmap(vcf)
}
\arguments{
\item{vcf}{a vcfR object.}
}
\value{
a data.frame that can be used as an input for GAPIT.
}
\description{
Converts a vcfR object to hapmap
}
\details{
Converts a vcfR object to a hapmap format.
}
\examples{
data(vcfR_test)
myHapMap <- vcfR2hapmap(vcfR_test)
class(myHapMap)
\dontrun{
# Example of how to create a (GAPIT compliant) HapMap file.
write.table(myHapMap, 
            file = "myHapMap.hmp.txt",
            sep = "\t", 
            row.names = FALSE,
            col.names = FALSE)
}

}
\author{
Brian J. Knaus
}
