% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_rep.R
\name{replicate.mean2}
\alias{replicate.mean2}
\title{Compares 2-group mean differences in original and follow-up studies}
\usage{
replicate.mean2(
  alpha,
  m11,
  m12,
  sd11,
  sd12,
  n11,
  n12,
  m21,
  m22,
  sd21,
  sd22,
  n21,
  n22
)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m11}{sample mean for group 1 in original study}

\item{m12}{sample mean for group 2 in original study}

\item{sd11}{sample SD for group 1 in original study}

\item{sd12}{sample SD for group 2 in original study}

\item{n11}{sample size for group 1 in original study}

\item{n12}{sample size for group 2 in original study}

\item{m21}{sample mean for group 1 in follow-up study}

\item{m22}{sample mean for group 2 in follow-up study}

\item{sd21}{sample SD for group 1 in follow-up study}

\item{sd22}{sample SD for group 2 in follow-up study}

\item{n21}{sample size for group 1 in follow-up study}

\item{n22}{sample size for group 2 in follow-up study}
}
\value{
A 4-row matrix. The rows are:
\itemize{
\item Row 1 summarizes the Original study
\item Row 2 summarizes the Follow-up study
\item Row 3 estimates the difference between studies
\item Row 4 estimates the average effect size between the two studies
}

The columns are:
\itemize{
\item Estimate - effect size estimate
\item SE - standard error
\item t - t-value
\item p - p-value
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
\item df - degrees of freedom
}
}
\description{
This function computes confidence intervals for a 2-group mean difference
from an original study and a follow-up study. Confidence intervals for the
difference and average effect size also are computed. A Satterthwaite
adjustment to the degrees of freedom is used to improve the accuracy of the
confidence intervals. The same results can be obtained using the \link[vcmeta]{meta.lc.mean2}
function with appropriate contrast coefficients. The confidence level for the
difference is 1 – 2alpha.
}
\examples{
replicate.mean2(.05, 21.9, 16.1, 3.82, 3.21, 40, 40, 
                     25.2, 19.1, 3.98, 3.79, 75, 75)

# Should return:
#                     Estimate        SE          t            p 
# Original:               5.80 0.7889312  7.3517180 1.927969e-10  
# Follow-up:              6.10 0.6346075  9.6122408 0.000000e+00  
# Original - Follow-up:  -0.30 1.0124916 -0.2962988 7.673654e-01 
# Average:                5.95 0.5062458 11.7531843 0.000000e+00 
#                               LL       UL        df
# Original:               4.228624 7.371376  75.75255
# Follow-up:              4.845913 7.354087 147.64728
# Original - Follow-up:  -1.974571 1.374571 169.16137
# Average:                4.950627 6.949373 169.16137


}
\references{
\insertRef{Bonett2021}{vcmeta}
}
