% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_se.R
\name{se.odds}
\alias{se.odds}
\title{Computes the standard error for a log odds ratio}
\usage{
se.odds(f1, n1, f2, n2)
}
\arguments{
\item{f1}{number of participants who have the outcome of interest in group 1}

\item{n1}{group 1 sample size}

\item{f2}{number of participants who have the outcome of interest in group 2}

\item{n2}{group 2 sample size}
}
\value{
Returns a one-row matrix:
\itemize{
\item Estimate - estimate of log odds ratio
\item SE - standard error
}
}
\description{
This function computes a log odds ratio and its standard error using
the frequency counts and sample sizes in a 2-group design. These
frequency counts and sample sizes can be obtained from a 2x2
contingency table. This function is useful in a meta-analysis of
odds ratios where some studies report the sample odds ratio and its
standard error and other studies only report the frequency counts
(or a 2x2 contingency table. The log odds ratio and standard error
output from this function can be used as input in the \link[vcmeta]{meta.ave.gen},
\link[vcmeta]{meta.lc.gen}, and \link[vcmeta]{meta.lm.gen} functions.
}
\examples{
se.odds(36, 50, 21, 50)

# Should return: 
#                 Estimate        SE
# Log odds ratio: 1.239501 0.4204435


}
\references{
\insertRef{Bonett2015}{vcmeta}
}
