% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hooks.R
\docType{data}
\name{Hooks}
\alias{Hooks}
\title{Hooks class}
\arguments{
\item{hooks}{List of hooks}

\item{hook_type, x}{(character) Hook name}

\item{args}{Args passed when invoking a hook}

\item{plac}{Placement, one of "start" or "end"}

\item{fun}{A function}

\item{prepend}{Whether to prepend or add to the end of the string.
Default: \code{FALSE}}
}
\description{
Hooks class
}
\details{
Helps define new hooks, hold hooks, and accessors to get and
use hooks.
\strong{Methods}
\describe{
\item{\code{invoke_hook(hook_type, args)}}{
Invoke a hook, i.e., call a hook.
}
\item{\code{clear_hooks()}}{
Remove all hooks.
}
\item{\code{define_hook(hook_type, fun, prepend = FALSE)}}{
Define a hook.
}
}
\strong{Private Methods}
\describe{
\item{\code{make_hook(x, plac, fun)}}{
Make a hook.
}
}
}
\examples{
\dontrun{
(x <- Hooks$new())
x$hooks
x$define_hook(hook_type = "foo", fun = function(x) x ^ 2)
x$hooks$foo(4)
x$clear_hooks()
x$hooks
}
}
\keyword{internal}
