% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dictionary.R
\name{vec_match}
\alias{vec_match}
\alias{vec_in}
\title{Find matching observations across vectors}
\usage{
vec_match(needles, haystack)

vec_in(needles, haystack)
}
\arguments{
\item{needles, haystack}{Vector of \code{needles} to search for in vector haystack.
\code{haystack} should usually be unique; if not \code{vec_match()} will only
return the location of the first match.

\code{needles} and \code{haystack} are coerced to the same type prior to
comparison.}
}
\value{
A vector the same length as \code{needles}. \code{vec_in()} returns a
logical vector; \code{vec_match()} returns an integer vector.
}
\description{
\code{vec_in()} returns a logical vector based on whether \code{needle} is found in
haystack. \code{vec_match()} returns an integer vector giving location of
\code{needle} in \code{haystack}, or \code{NA} if it's not found.
}
\details{
\code{vec_in()} is equivalent to \link{\%in\%}; \code{vec_match()} is equivalen to \code{match()}.
}
\section{Missing values}{

In most cases, missing values are not considered to be equal, i.e.
\code{NA == NA} is not \code{TRUE}. This behaviour would be unappealing here,
so these functions consider all \code{NAs} to be equal. (Similarly,
all \code{NaN} are also considered to be equal.)
}

\section{Performance}{

These functions are currently slightly slower than their base equivalents.
This is primarily because they do a little more checking and coercion
in R, which makes them both a litter safer and more generic. Additionally,
the C code underlying vctrs has not yet been implemented: we expect
some performance improvements when that happens.
}

\examples{
hadley <- strsplit("hadley", "")[[1]]
vec_match(hadley, letters)

vowels <- c("a", "e", "i", "o", "u")
vec_match(hadley, vowels)
vec_in(hadley, vowels)

# Only the first index of duplicates is returned
vec_match(c("a", "b"), c("a", "b", "a", "b"))
}
