% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ptype-abbr-full.R
\name{vec_ptype_full}
\alias{vec_ptype_full}
\alias{vec_ptype_abbr}
\title{Vector type as a string}
\usage{
vec_ptype_full(x, ...)

vec_ptype_abbr(x, ..., prefix_named = FALSE, suffix_shape = TRUE)
}
\arguments{
\item{x}{A vector.}

\item{...}{These dots are for future extensions and must be empty.}

\item{prefix_named}{If \code{TRUE}, add a prefix for named vectors.}

\item{suffix_shape}{If \code{TRUE} (the default), append the shape of
the vector.}
}
\value{
A string.
}
\description{
\code{vec_ptype_full()} displays the full type of the vector. \code{vec_ptype_abbr()}
provides an abbreviated summary suitable for use in a column heading.
}
\section{S3 dispatch}{

The default method for \code{vec_ptype_full()} uses the first element of the
class vector. Override this method if your class has parameters that should
be prominently displayed.

The default method for \code{vec_ptype_abbr()} \code{\link[=abbreviate]{abbreviate()}}s \code{vec_ptype_full()}
to 8 characters. You should almost always override, aiming for 4-6
characters where possible.

These arguments are handled by the generic and not passed to methods:
\itemize{
\item \code{prefix_named}
\item \code{suffix_shape}
}
}

\examples{
cat(vec_ptype_full(1:10))
cat(vec_ptype_full(iris))

cat(vec_ptype_abbr(1:10))
}
\keyword{internal}
