\encoding{UTF-8}
\name{clustconst}
\alias{clustconst}
\alias{summary.clustconst}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Constancy table of a classification
}
\description{
Allows studying the constancy table (i.e. the frequency of species in each class) of a classification represented in the form of a membership data matrix.
}
\usage{
clustconst(x, memb)
\method{summary}{clustconst}(object, mode="all", name=NULL, sort=TRUE, minconst=0.5, digits=3, ...)

}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{
Community data, a site by species data frame.
   }
  \item{memb}{
	An site-by-group matrix indicating the (hard or fuzzy) membership of each object in \code{x} to a set of groups.
   }
  \item{object}{An object of class 'clustconst'.}
  \item{mode}{Use \code{mode="all"} to print the constancy table, \code{mode="cluster"} to print constancy values for one cluster, and \code{mode="species"}, to print constancy values for one species.}
  \item{name}{A string with the name of a cluster (in \code{mode="cluster"}), or the name of a species (in \code{mode="species"}).}
  \item{sort}{A flag to indicate whether constancy table should be sorted in descending order.}
  \item{minconst}{A threshold used to limit the values shown.}
  \item{digits}{The number of digits for rounding.}
  \item{...}{Additional parameters for summary (actually not used).}
}
\details{
  The constancy value of a species in a vegetation unit is the relative frequency of occurrence of the species in plot records that belong to the unit. In case of a fuzzy vegetation unit the constancy value is the sum of memberships of sites that contain the species divided by the sum of memberships of all sites. Use the 'summary' function to obtain information about: (1) which species are more frequent on a given vegetation unit; (2) which vegetation units have higher frequencies of a given target species. Additionally, the 'summary' function can sort a constancy table if \code{mode="all"} and \code{sort=TRUE} are indicated.
}
\value{
 Function \code{clustconst} returns an object of type 'clustconst', in fact a data frame with the constancy value of each species (rows) on each cluster (column).
}
\author{
Miquel De \enc{Cáceres}{Caceres}, Forest Science Center of Catalonia
}

\seealso{
\code{\link{vegclust}}, \code{\link{kmeans}}
}
\examples{
## Loads stats
library(stats)  

## Loads data  
data(wetland)
  
## This equals the chord transformation 
## (see also \code{\link{decostand}} in package 'vegan')
wetland.chord = as.data.frame(sweep(as.matrix(wetland), 1, 
                              sqrt(rowSums(as.matrix(wetland)^2)), "/"))

## Performs a K-means clustering
wetland.km = kmeans(wetland.chord, centers=3, nstart=10)

## Gets constancy table of KM (i.e. hard) clusters
c=clustconst(wetland.chord, memb=as.memb(wetland.km$cluster))

## Prints constancy values ordered and store the result in d
d=summary(c, mode="all")

## Prints the most frequent species in the first cluster
summary(c, mode="cluster", name=names(c)[1])
}
