% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.R
\name{subset}
\alias{subset}
\alias{subset,vegtable-method}
\title{Subset functions for vegtable objects}
\usage{
\S4method{subset}{vegtable}(
  x,
  subset,
  slot = "header",
  keep_children = FALSE,
  keep_parents = FALSE,
  ...
)
}
\arguments{
\item{x}{A \linkS4class{vegtable} object for subset.}

\item{subset}{Logical vector or operation for subset.}

\item{slot}{Slot to be applied for subset.}

\item{keep_children}{Argument passed to \code{\link[taxlist:subset]{taxlist::subset()}}.}

\item{keep_parents}{Argument passed to \code{\link[taxlist:subset]{taxlist::subset()}}.}

\item{...}{Further arguments passed from or to other methods.}
}
\value{
A S4 object of class \linkS4class{vegtable}.
}
\description{
Produce subsets of \linkS4class{vegtable} objects.

This function generate subsets of \linkS4class{vegtable} objects through logical
operations. Such operations can be applied either to the plots, or the
relations, which are the main slots in that class.

This method can be referred to the slot \code{species} the same way as
\code{\link[taxlist:subset]{taxlist::subset()}}, then the rest of the data will include only
references to the subset of species list.
}
\examples{
summary(dune_veg)

## Select plots used as pastures
Pastures <- subset(dune_veg, Use == "Pasture", slot="header")
summary(Pastures)

}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}
}
