% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emis_post.R
\name{emis_post}
\alias{emis_post}
\title{Post emissions}
\usage{
emis_post(arra, veh, size, fuel, pollutant, by = "veh")
}
\arguments{
\item{arra}{Array of emissions 4d: streets x category of vehicles x hours x days or
3d: streets x category of vehicles x hours}

\item{veh}{Type of vehicle}

\item{size}{Size or weight}

\item{fuel}{Fuel}

\item{pollutant}{Pollutant}

\item{by}{Type of output, "veh" for total vehicular category ,
"streets_narrow" or "streets_wide". "streets_wide" returns  a dataframe with
 rows as number of streets and columns the hours as days*hours considered, e.g.
168 columns as the hours of a whole week and "streets_wide repeats the
row number of streets by hour and day of the week}
}
\description{
Simplify emissions estimated as total per type category of vehicle or
by street. It reads EmissionsArray. It can return an dataframe with hourly
emissions at each street, or a data base with emissions by vehicular
category, hour, including size, fuel and other characteristics.
}
\examples{
\dontrun{
# Do not run
data(net)
data(pc_profile)
data(fe2015)
data(fkm)
PC_G <- c(33491,22340,24818,31808,46458,28574,24856,28972,37818,49050,87923,
          133833,138441,142682,171029,151048,115228,98664,126444,101027,
          84771,55864,36306,21079,20138,17439, 7854,2215,656,1262,476,512,
          1181, 4991, 3711, 5653, 7039, 5839, 4257,3824, 3068)
veh <- data.frame(PC_G = PC_G)
pc1 <- my_age(x = net$ldv, y = PC_G, name = "PC")
pcw <- temp_fact(net$ldv+net$hdv, pc_profile)
speed <- netspeed(pcw, net$ps, net$ffs, net$capacity, net$lkm, alpha = 1)
pckm <- fkm[[1]](1:24); pckma <- cumsum(pckm)
cod1 <- emis_det(po = "CO", cc = 1000, eu = "III", km = pckma[1:11])
cod2 <- emis_det(po = "CO", cc = 1000, eu = "I", km = pckma[12:24])
#vehicles newer than pre-euro
co1 <- fe2015[fe2015$Pollutant=="CO", ] #24 obs!!!
cod <- c(co1$PC_G[1:24]*c(cod1,cod2),co1$PC_G[25:nrow(co1)])
lef <- ef_ldv_scaled(co1, cod, v = "PC",  cc = "<=1400",
                     f = "G",p = "CO", eu=co1$Euro_LDV)
lef <- c(lef,lef[length(lef)],lef[length(lef)],lef[length(lef)],
         lef[length(lef)],lef[length(lef)])
E_CO <- emis(veh = pc1,lkm = net$lkm, ef = lef, speed = speed, agemax = 41,
             profile = pc_profile)
# arguments required: arra, pollutant ad by
E_CO_STREETS <- emis_post(arra = E_CO, pollutant = "CO", by = "streets_wide")
summary(E_CO_STREETS)
# arguments required: arra, veh, size, fuel, pollutant ad by
E_CO_DF <- emis_post(arra = E_CO,  veh = "PC", size = "<1400", fuel = "G",
pollutant = "CO", by = "veh")
head(E_CO_DF)
# recreating 24 profile
lpc <-list(pc1*0.2, pc1*0.1, pc1*0.1, pc1*0.2, pc1*0.5, pc1*0.8,
           pc1, pc1*1.1, pc1,
           pc1*0.8, pc1*0.5, pc1*0.5,
           pc1*0.5, pc1*0.5, pc1*0.5, pc1*0.8,
           pc1, pc1*1.1, pc1,
           pc1*0.8, pc1*0.5, pc1*0.3, pc1*0.2, pc1*0.1)
E_COv2 <- emis(veh = lpc,  lkm = net$lkm, ef = lef, speed = speed[, 1:24],
            agemax = 41, hour = 24, day = 1)
plot(E_COv2)
E_CO_DFv2 <- emis_post(arra = E_COv2,  veh = "PC", size = "<1400", fuel = "G",
pollutant = "CO", by = "veh")
}
}
