% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age_ldv.R
\name{age_ldv}
\alias{age_ldv}
\title{Returns amount of vehicles at each age}
\usage{
age_ldv(x, name = "veh", a = 1.698, b = -0.2, agemin = 1, agemax = 50,
  k = 1, bystreet = F, net, message = TRUE)
}
\arguments{
\item{x}{numerical vector of vehicles}

\item{name}{word of vehicle assigned to columns of dataframe}

\item{a}{parameter of survival equation}

\item{b}{parameter of survival equation}

\item{agemin}{age of newest vehicles for that category}

\item{agemax}{age of oldest vehicles for that category}

\item{k}{multiplication factor}

\item{bystreet}{when TRUE it is expecting that 'a' and 'b' are numeric
vectors with length equal to x}

\item{net}{SpatialLinesDataFrame or Spatial Feature of "LINESTRING"}

\item{message}{message with average age and total numer of vehicles}
}
\value{
dataframe of age distrubution of vehicles
}
\description{
Returns amount of vehicles at each age
}
\examples{
{
data(net)
PC_E25_1400 <- age_ldv(x = net$ldv, name = "PC_E25_1400")
plot(PC_E25_1400)
PC_E25_1400 <- age_ldv(x = net$ldv, name = "PC_E25_1400", net = net)
plot(PC_E25_1400)
}
}
