% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ef_local.R
\name{ef_local}
\alias{ef_local}
\title{Local Emissions factors}
\usage{
ef_local(
  p,
  veh,
  year = 2017,
  agemax = 40,
  ef,
  full = FALSE,
  project = "constant",
  verbose = TRUE
)
}
\arguments{
\item{p}{Character; pollutant delivered by the user. the name of the column of the data.frame must be
\strong{Pollutant}.}

\item{veh}{Character; Vehicle categories available in the data.frame provided by the user}

\item{year}{Numeric; Filter the emission factor to start from a specific base year.
If project is 'constant' values above 2017 and below 1980 will be repeated}

\item{agemax}{Integer; age of oldest vehicles for that category}

\item{ef}{data.frame, for local the emission factors. The names of the ef must
be `Age`    `Year`    `Pollutant` and all the vehicle categories...}

\item{full}{Logical; To return a data.frame instead or a vector adding
Age, Year, Brazilian emissions standards and its euro equivalents.}

\item{project}{Character showing the method for projecting emission factors in
future. Currently the only value is "constant"}

\item{verbose}{Logical; To show more information}
}
\value{
A vector of Emission Factor or a data.frame
}
\description{
\code{\link{ef_local}} process an data.frame delivered by the user, but adding
similar funcionality and arguments as \code{\link{ef_cetesb}}, which are classification, filtering
and projections
}
\details{
returns a vector or data.frame of Brazilian emission factors.
}
\note{
The names of the ef must be `Age`	`Year`	`Pollutant` and all the vehicle categories...
}
\examples{
\dontrun{
#do not run
}
}
\seealso{
\code{\link{ef_cetesb}}
}
\keyword{emission}
\keyword{factors}
