% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ef_ive.R
\name{ef_ive}
\alias{ef_ive}
\title{Base emissions factors from International Vehicle Emissions (IVE) model}
\usage{
ef_ive(
  description = "Auto/Sml Truck",
  fuel = "Petrol",
  weight = "Light",
  air_fuel_control = "Carburetor",
  exhaust = "None",
  evaporative = "PCV",
  mileage,
  pol,
  details = FALSE
)
}
\arguments{
\item{description}{Character; "Auto/Sml Truck" "Truck/Bus" or"Sml Engine".}

\item{fuel}{Character; "Petrol", "NG Retrofit", "Natural Gas", "Prop Retro.",
"Propane", "EthOH Retrofit", "OEM Ethanol", "Diesel", "Ethanol" or "CNG/LPG".}

\item{weight}{Character; "Light", "Medium", "Heavy", "Lt", "Med" or "Hvy"}

\item{air_fuel_control}{Character; One of the following characters: "Carburetor",
"Single-Pt FI", "Multi-Pt FI", "Carb/Mixer", "FI", "Pre-Chamber Inject.",
"Direct Injection", "2-Cycle", "2-Cycle, FI", "4-Cycle, Carb", "4-Cycle, FI"
"4-Cycle"}

\item{exhaust}{Character: "None", "2-Way", "2-Way/EGR", "3-Way", "3-Way/EGR",
"None/EGR", "LEV", "ULEV", "SULEV", "EuroI", "EuroII", "EuroIII", "EuroIV",
"Hybrid", "Improved", "EGR+Improv", "Particulate", "Particulate/NOx",
"EuroV", "High Tech" or "Catalyst"}

\item{evaporative}{Character: "PCV", "PCV/Tank" or"None".}

\item{mileage}{Numeric; mileage of vehicle by age of use km.}

\item{pol}{Character; One of the following characters: "Carburetor",
"Single-Pt FI", "Multi-Pt FI", "Carb/Mixer", "FI", "Pre-Chamber Inject.",
"Direct Injection", "2-Cycle", "2-Cycle, FI", "4-Cycle, Carb", "4-Cycle, FI"
"4-Cycle"
#' \tabular{cccc}{
  "VOC_gkm" \tab "CO_gkm" \tab "NOx_gkm" \tab "PM_gkm" \cr
  "Pb_gkm" \tab "SO2_gkm" \tab "NH3_gkm" \tab "1,3-butadiene_gkm" \cr
  "formaldehyde_gkm" \tab "acetaldehyde_gkm" \tab "benzene_gkm" \tab "EVAP_gkm" \cr
  "CO2_gkm" \tab "N20_gkm" \tab "CH4_gkm" \tab "VOC_gstart" \cr
  "CO_gstart" \tab "NOx_gstart" \tab "PM_gstart" \tab "Pb_gstart" \cr
  "SO2_gstart" \tab "NH3_gstart" \tab "1,3-butadiene_gstart" \tab "formaldehyde_gstart" \cr
  "acetaldehyde_gstart" \tab "benzene_gstart" \tab "EVAP_gstart" \tab "CO2_gstart" \cr
  "N20_gstart" \tab "CH4_gstart" \tab   \tab  \cr
}}

\item{details}{Logical; option to see or not more information about vehicle.}
}
\value{
An emission factor by annual mileage.
}
\description{
\code{\link{ef_ive}} returns the base emission factors from the the IVE
model. This function depend on vectorized mileage, which means your can
enter with the mileage by age of use and the name of the pollutant.
}
\examples{
\dontrun{
# Do not run
# Passenger Cars PC
data(fkm)
# cumulative mileage from 1 to 50 years of use, 40:50
mil <- cumsum(fkm$KM_PC_E25(1:50))
ef_ive("Truck/Bus", mileage = mil, pol = "CO_gkm")
ef_ive(mileage = mil, pol = "CO_gkm", details = TRUE)
}
}
\references{
Nicole Davis, James Lents, Mauricio Osses, Nick Nikkila,
 Matthew Barth. 2005. Development and Application of an International
 Vehicle Emissions Model. Transportation Research Board, 81st Annual Meeting,
 January 2005, Washington, D.C.
}
\keyword{emission}
\keyword{factors}
\keyword{ive}
\keyword{speed}
