% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/language.R
\name{addVideoLanguages}
\alias{addVideoLanguages}
\alias{availableLanguages}
\title{Add Language Support}
\usage{
addVideoLanguages(video, languages)

availableLanguages()
}
\arguments{
\item{video}{A \code{\link{video}}}

\item{languages}{A character vector of languages to support in the video.
See \code{availableVideoLanguages()} for a full list}
}
\value{
An updated \code{video} with extra language support
}
\description{
Enabling languages (other than English) to appear as tooltips and other buttons in video.js widgets.
}
\details{
If any languages are missing, you can add a separate script in the head of the application
that will apply the language to all videos. See \url{https://videojs.com/guides/languages/}
for more details
}
\examples{
video <- video("https://vjs.zencdn.net/v/oceans.mp4")
video <- addVideoLanguages(video, c("es", "fr", "de"))

if (interactive()) {
  library(shiny)

  ui <- fluidPage(lang = "fr", video)
  server <- function(input, output) {}
  shinyApp(ui, server)
}

}
