% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viewpar.R
\name{view.par}
\alias{view.par}
\title{Compute visibility in 3D TLS scene with parallel computation}
\usage{
view.par(data, param, scene.center, shape, scene.radius, plot.result,
  ncores)
}
\arguments{
\item{data}{a data.frame containing the xyz coordinates of a TLS point cloud}

\item{param}{a data.frame containing the directions that will be used to explore the point cloud}

\item{scene.center}{a vector containing the xyz coordinates of the scene center. Default is 0,0,0.}

\item{shape}{the shape of the scene radius reshaping (see \code{\link{reshape.scene}} function for more details). Default = "3d".}

\item{scene.radius}{the cut-off distance relative to the \emph{scene.center}}

\item{plot.result}{logical. If \emph{TRUE} the \% of visibility vs. distance is ploted}

\item{ncores}{the number of cores to use for parallel computation. Default is N detected cores-1}
}
\value{
a data.frame containing the distance, the number of points found at this distance and the \% of remaining visibility and the distance
}
\description{
The \strong{view.par} function is similar to the \code{\link{view}} with paralel computation capabilities.
}
\note{
some existing parameters are already provided with the viewshed3d package with parameters for an angular resolution ranging from 1 to 10 : \link{param_1},
\link{param_2}, \link{param_3}, \link{param_4}, \link{param_5}, \link{param_6}, \link{param_7}, \link{param_8}, \link{param_9}, \link{param_10}.
}
