% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_example_tables.R
\name{create_example_tables}
\alias{create_example_tables}
\alias{create_ex_main_txt}
\alias{create_ex_sub_txt}
\alias{create_ex_who_txt}
\alias{create_ex_meddra_asc}
\alias{create_ex_main_pq}
\title{Example source tables for VigiBase and MedDRA}
\usage{
create_ex_main_txt(path)

create_ex_sub_txt(path)

create_ex_who_txt(path)

create_ex_meddra_asc(path)

create_ex_main_pq(path)
}
\arguments{
\item{path}{Character string. A folder on your computer where the tables should
be written.}
}
\value{
A set of text/ascii files,
as received by the Uppsala Monitoring Centre or MedDRA
\itemize{
\item For \code{\link[=create_ex_main_txt]{create_ex_main_txt()}},
DEMO.txt, DRUG.txt, LINK.txt, FOLLOWUP.txt,
ADR.txt, OUT.txt, SRCE.txt, and IND.txt
\item For \code{\link[=create_ex_sub_txt]{create_ex_sub_txt()}},
AgeGroup_Lx.txt, Dechallenge_Lx.txt, Dechallenge2_Lx.txt,
Frequency_Lx.txt, Gender_Lx.txt, Notifier_Lx.txt, Outcome_Lx.txt,
Rechallenge_Lx.txt, Rechallenge2_Lx.txt, Region_Lx.txt, RepBasis_Lx.txt,
ReportType_Lx.txt, RouteOfAdm_Lx.txt, Seriousness_Lx.txt,
and SizeUnit_Lx.txt
\item For \code{\link[=create_ex_who_txt]{create_ex_who_txt()}},
ATC.txt, CCODE.txt, ING.txt, MP.txt, ORG.txt,
PF.txt, PP.txt, PRT.txt, PRG.txt, SRCE.txt, STR.txt,
SUN.txt, ThG.txt, and Unit-X.txt
\item For \code{\link[=create_ex_meddra_asc]{create_ex_meddra_asc()}},
llt.asc, mdhier.asc, smq_content.asc, smq_list.asc
\item For \code{\link[=create_ex_main_pq]{create_ex_main_pq()}},
demo.parquet, adr.parquet, drug.parquet, link.parquet,
srce.parquet, ind.parquet, out.parquet, followup.parquet, suspdup.parquet
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Write some example
tables as source text/ascii/parquet files.
}
\details{
VigiBase tables and MedDRA tables are provided respectively
as text files and ascii files. The \verb{tb_*} family turns them
into parquet files. These \verb{create_example_*} functions are only used to produce
example source files to illustrate the \verb{tb_*} family, and parquet files for the
same purpose.
}
\section{Functions}{
\itemize{
\item \code{create_ex_sub_txt()}: sub txt tables

\item \code{create_ex_who_txt()}: WHO txt tables

\item \code{create_ex_meddra_asc()}: MedDRA txt tables

\item \code{create_ex_main_pq()}: main parquet tables

}}
\examples{

path <- paste0(tempdir(), "/crex/")

dir.create(path)

# You may want to use different paths for each type of tables
create_ex_main_txt(path)

create_ex_sub_txt(path)

create_ex_who_txt(path)

create_ex_meddra_asc(path)

create_ex_main_pq(path)

# Remove temporary folders when you're done
unlink(path, recursive = TRUE)
}
\seealso{
\code{\link[=tb_vigibase]{tb_vigibase()}}, \code{\link[=tb_who]{tb_who()}}, \code{\link[=tb_meddra]{tb_meddra()}}
}
