% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vimp_anova.R
\name{vimp_anova}
\alias{vimp_anova}
\title{Nonparametric Intrinsic Variable Importance Estimates: ANOVA}
\usage{
vimp_anova(
  Y = NULL,
  X = NULL,
  f1 = NULL,
  f2 = NULL,
  indx = 1,
  V = 10,
  run_regression = TRUE,
  SL.library = c("SL.glmnet", "SL.xgboost", "SL.mean"),
  alpha = 0.05,
  delta = 0,
  na.rm = FALSE,
  scale = "identity",
  folds,
  stratified = FALSE,
  C = rep(1, length(Y)),
  Z = NULL,
  ipc_weights = rep(1, length(Y)),
  ipc_est_type = "aipw",
  ...
)
}
\arguments{
\item{Y}{the outcome.}

\item{X}{the covariates.}

\item{f1}{the predicted values on validation data from a flexible estimation 
technique regressing Y on X in the training data; a list of length V, 
where each object is a set of predictions on the validation data.}

\item{f2}{the predicted values on validation data from a flexible estimation 
technique regressing the fitted values in \code{f1} on X withholding the 
columns in \code{indx}; a list of length V, where each object is a set of 
predictions on the validation data.}

\item{indx}{the indices of the covariate(s) to calculate variable importance 
for; defaults to 1.}

\item{V}{the number of folds for cross-validation, defaults to 10.}

\item{run_regression}{if outcome Y and covariates X are passed to 
\code{cv_vim}, and \code{run_regression} is \code{TRUE}, then 
Super Learner will be used; otherwise, variable importance will be 
computed using the inputted fitted values.}

\item{SL.library}{a character vector of learners to pass to 
\code{SuperLearner}, if \code{run_regression = TRUE}.
Defaults to \code{SL.glmnet}, \code{SL.xgboost}, and \code{SL.mean}.}

\item{alpha}{the level to compute the confidence interval at. Defaults to 
0.05, corresponding to a 95\% confidence interval.}

\item{delta}{the value of the \eqn{\delta}-null (i.e., testing if 
importance < \eqn{\delta}); defaults to 0.}

\item{na.rm}{should we remove NA's in the outcome and fitted values in 
computation? (defaults to \code{FALSE})}

\item{scale}{scale should CIs be computed on original ("identity") or 
logit ("logit") scale? (defaults to "identity")}

\item{folds}{the folds to use, if f1 and f2 are supplied.}

\item{stratified}{if run_regression = TRUE, then should the generated folds 
be stratified based on the outcome? (helps to ensure class balance across 
cross-validation folds)}

\item{C}{the indicator of coarsening (1 denotes observed, 0 denotes 
unobserved).}

\item{Z}{either (i) NULL (the default, in which case the argument 
\code{C} above must be all ones), or (ii) a character list specifying the 
variable(s) among Y and X that are thought to play a role in the coarsening 
mechanism.}

\item{ipc_weights}{weights for the computed influence curve 
(i.e., inverse probability weights for coarsened-at-random settings).}

\item{ipc_est_type}{IPC correction, either \code{"ipw"} (for classical 
inverse probability weighting) or \code{"aipw"} (for augmented inverse
probability weighting; the default).}

\item{...}{other arguments to the estimation tool, see "See also".}
}
\value{
An object of classes \code{vim} and \code{vim_regression}. 
  See Details for more information.
}
\description{
Compute estimates of and confidence intervals for nonparametric ANOVA-based 
intrinsic variable importance. This is a wrapper function for \code{cv_vim}, 
with \code{type = "anova"}.
}
\details{
See the paper by Williamson, Gilbert, Simon, and Carone for more
details on the mathematics behind this function, and the validity
of the confidence intervals.
In the interest of transparency, we return most of the calculations
within the \code{vim} object. This results in a list containing:
\itemize{
 \item{s}{ - the column(s) to calculate variable importance for}
 \item{SL.library}{ - the library of learners passed to \code{SuperLearner}}
 \item{full_fit}{ - the fitted values of the chosen method fit to the full data}
 \item{red_fit}{ - the fitted values of the chosen method fit to the reduced data}
 \item{est}{ - the estimated variable importance}
 \item{naive}{ - the naive estimator of variable importance}
 \item{update}{ - the influence curve-based update}
 \item{se}{ - the standard error for the estimated variable importance}
 \item{ci}{ - the \eqn{(1-\alpha) \times 100}\% confidence interval for the variable importance estimate}
 \item{full_mod}{ - the object returned by the estimation procedure for the full data regression (if applicable)}
 \item{red_mod}{ - the object returned by the estimation procedure for the reduced data regression (if applicable)}
 \item{alpha}{ - the level, for confidence interval calculation}
 \item{y}{ - the outcome}
}
}
\examples{
# generate the data
# generate X
p <- 2
n <- 100
x <- data.frame(replicate(p, stats::runif(n, -5, 5)))

# apply the function to the x's
smooth <- (x[,1]/5)^2*(x[,1]+7)/5 + (x[,2]/3)^2

# generate Y ~ Normal (smooth, 1)
y <- smooth + stats::rnorm(n, 0, 1)

# set up a library for SuperLearner; note simple library for speed
library("SuperLearner")
learners <- c("SL.glm", "SL.mean")

# estimate (with a small number of folds, for illustration only)
est <- vimp_anova(y, x, indx = 2,
           alpha = 0.05, run_regression = TRUE,
           SL.library = learners, V = 2, cvControl = list(V = 2))

}
\seealso{
\code{\link[SuperLearner]{SuperLearner}} for specific usage of the 
  \code{SuperLearner} function and package.
}
