% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/visOptions.R
\name{visOptions}
\alias{visOptions}
\title{Network visualization general options}
\usage{
visOptions(graph, width = NULL, height = NULL, highlightNearest = FALSE,
  nodesIdSelection = FALSE, autoResize = NULL, clickToUse = NULL,
  manipulation = NULL)
}
\arguments{
\item{graph}{: a visNetwork object}

\item{width}{: String. Default to "100\%". The width of the network in pixels or as a percentage.}

\item{height}{: String. Default to "100\%". The height of the network in pixels or as a percentage.}

\item{highlightNearest}{: Custom Option. Boolean. Default to false. Highlight nearest when clicking a node ?
This options use click event. Not available for DOT and Gephi.}

\item{nodesIdSelection}{:  Custom Option. Boolean. Default to false. A little bit experimental. Add an id node selection. This options use click event. Not available for DOT and Gephi.}

\item{autoResize}{: Boolean. Default to true. If true, the Network will automatically detect when its container is resized, and redraw itself accordingly. If false, the Network can be forced to repaint after its container has been resized using the function redraw() and setSize().}

\item{clickToUse}{: Boolean. Default to false. When a Network is configured to be clickToUse, it will react to mouse, touch, and keyboard events only when active. When active, a blue shadow border is displayed around the Network. The Network is set active by clicking on it, and is changed to inactive again by clicking outside the Network or by pressing the ESC key.}

\item{manipulation}{: Just a Boolean}
}
\description{
Network visualization general options. For full documentation, have a look at \link{visDocumentation}.
}
\seealso{
\link{visNodes} for nodes options, \link{visEdges} for edges options, \link{visGroups} for groups options,
\link{visLayout} & \link{visHierarchicalLayout} for layout, \link{visPhysics} for physics, \link{visInteraction} for interaction, ...
}

