% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customiseText.R
\name{customiseText}
\alias{customiseText}
\title{Apply styling to text or column names}
\usage{
customiseText(
  x,
  fun = function(x) stringr::str_to_sentence(gsub("_", " ", x)),
  custom = NULL,
  keep = NULL
)
}
\arguments{
\item{x}{A character vector to style text.}

\item{fun}{A styling function to apply to text in \code{x}. The default function
converts snake_case to sentence case.}

\item{custom}{A named character vector indicating custom names for specific
values in \code{x}. If NULL, the styling function in \code{fun} is applied to all
values.}

\item{keep}{Either a character vector of names to keep unchanged. If NULL,
all names will be styled.}
}
\value{
A character vector of styled text or a data frame with styled column
names.
}
\description{
This function styles character vectors or column names in a data frame.
The styling function can be customized, or you can provide specific
replacements for certain values.
}
\examples{
# Styling a character vector
customiseText(c("some_column_name", "another_column"))

# Custom styling for specific values
customiseText(x = c("some_column", "another_column"),
          custom = c("Custom Name" = "another_column"))

# Keeping specific values unchanged
customiseText(x = c("some_column", "another_column"), keep = "another_column")

# Styling column names and variables in a data frame
dplyr::tibble(
  some_column = c("hi_there", "rename_me", "example", "to_keep"),
  another_column = 1:4,
  to_keep = "as_is"
) |>
  dplyr::mutate(
    "some_column" = customiseText(some_column, custom = c("EXAMPLE" = "example"), keep = "to_keep")
  ) |>
  dplyr::rename_with(.fn = ~ customiseText(.x, keep = "to_keep"))
}
