% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatter_plot.R
\name{scatter_plot}
\alias{scatter_plot}
\title{scatter_plot}
\usage{
scatter_plot(
  data,
  xAccessor,
  yAccessor,
  groupAccessor = "",
  mainTitle = "",
  subTitle = "",
  accessibility = list(),
  props = list(),
  ...
)
}
\arguments{
\item{data}{required to be a valid, R data frame. Data used to create chart, an array of objects which includes keys that map to chart accessors.}

\item{xAccessor}{String. Key used to determine each point's position along the x-axis.}

\item{yAccessor}{String. Key used to determine each point's position along the y-axis.}

\item{groupAccessor}{String. Key used to determine bar group encoding (e.g., color/texture).}

\item{mainTitle}{String. The dynamic tag of title for the map (or you can create your own separately). See \code{highestHeadingLevel} prop for how tags get assigned.}

\item{subTitle}{String. The dynamic tag for a sub title for the map (or you can create your own separately). See \code{highestHeadingLevel} prop for how tags get assigned.}

\item{accessibility}{List(). Manages messages and settings for chart accessibility, see \href{https://github.com/visa/visa-chart-components/tree/master/packages/scatter-plot#accessibility-props}{object definition}}

\item{props}{List(). A valid R list with additional property configurations, see all props for \href{https://github.com/visa/visa-chart-components/tree/master/packages/scatter-plot}{@visa/scatter-plot}}

\item{...}{All other props passed into the function will be passed through to the chart, see all props for \href{https://github.com/visa/visa-chart-components/tree/master/packages/scatter-plot}{@visa/scatter-plot}.}
}
\value{
a visaChart htmlwidget object for plotting a scatter plot
}
\description{
R wrapper for \href{https://github.com/visa/visa-chart-components/tree/master/packages/scatter-plot}{@visa/scatter-plot} via \href{https://www.htmlwidgets.org/}{htmlwidgets}.

Here is an example of scatter-plot in action:

\if{html}{\figure{scatter-plot-1.png}{options: width=400 alt="example scatter plot"}}
}
\details{
To see all available options for the chart properties/API see \href{https://github.com/visa/visa-chart-components/tree/master/packages/scatter-plot}{@visa/scatter-plot}.
}
\examples{
library(dplyr)
scatter_plot(mtcars[order(mtcars$cyl),], "wt", "mpg", "cyl")
}
