% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_shannon.R
\name{plot_shannon}
\alias{plot_shannon}
\title{plot_shannon}
\usage{
plot_shannon(shannon_df)
}
\arguments{
\item{shannon_df}{A dataframe that has been arranged (arrange_data), filtered (filter_variants), and piped through the Shannon calculations (shannon_entropy)}
}
\value{
Three plots showing the nt Shannon, chrom Shannon, and full genome Shannon calculations
}
\description{
Reads in a dataframe that has been arranged (arrange_data), filtered (filter_variants), and piped through the Shannon calculations (shannon_entropy) and outputs plots
}
\details{
The `plot_shannon()` function takes the variant dataframe and generates three plots.
1. The Shannon entropy, or amount of diversity, at each position in the genome at which a variant was found.
2. The Shannon entropy summed over each segment
3. The Shannon entropy summed over each genome
A higher value indicates more diversity.
}
\examples{
# Sample dataframe
df <- data.frame(sample = c("m1", "m2", "m1", "m2", "m1"),
                 CHROM = c("PB1", "PB1", "PB2", "PB2", "NP"),
                 POS = c(234, 234, 240, 240, 254),
                 minorfreq = c(0.010, 0.022, 0.043, 0.055, 0.011),
                 majorfreq = c(0.990, 0.978, 0.957, 0.945, 0.989),
                 SegmentSize = c(2280, 2280, 2274, 2274, 1809)
)

df

genome_size = 13133

# Modify the dataframe to add 5 new columns of shannon entropy data:
# 1. shannon_ntpos
# 2. chrom_shannon
# 3. genome_shannon
# 4. shannon_chrom_perkb
# 5. genome_shannon_perkb
shannon_df = shannon_entropy(df, genome_size)

# Plot
plot_shannon(shannon_df)

}
