% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viviHeatmap.R
\name{viviHeatmap}
\alias{viviHeatmap}
\title{viviHeatmap}
\usage{
viviHeatmap(
  mat,
  intPal = rev(colorspace::sequential_hcl(palette = "Purples 3", n = 100)),
  impPal = rev(colorspace::sequential_hcl(palette = "Greens 3", n = 100)),
  intLims = NULL,
  impLims = NULL,
  border = FALSE,
  angle = 0
)
}
\arguments{
\item{mat}{A matrix, such as that returned by vivi, of values to be plotted.}

\item{intPal}{A vector of colours to show interactions, for use with scale_fill_gradientn.}

\item{impPal}{A vector of colours to show importance, for use with scale_fill_gradientn.}

\item{intLims}{Specifies the fit range for the color map for interaction strength.}

\item{impLims}{Specifies the fit range for the color map for importance.}

\item{border}{Logical. If TRUE then draw a black border around the diagonal elements.}

\item{angle}{The angle to rotate the x-axis labels. Defaults to zero.}
}
\value{
A heatmap plot showing variable importance on the diagonal
and variable interaction on the off-diagonal.
}
\description{
Plots a Heatmap showing variable importance on the diagonal
and variable interaction on the off-diagonal.
}
\examples{
\donttest{
library(ranger)
aq <- na.omit(airquality)
rF <- ranger(Ozone ~ ., data = aq, importance = "permutation")
myMat <- vivi(fit = rF, data = aq, response = "Ozone")
viviHeatmap(myMat)
}
}
