% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{ell}
\alias{ell}
\title{Estimated log-likelihood.}
\usage{
ell(s, y, delta)
}
\arguments{
\item{s}{Integer vector. Parsonnet Score values within a range of \code{0} to \code{100}
representing the preoperative patient risk.}

\item{y}{Double. Binary (\code{0/1}) outcome values of each operation.}

\item{delta}{Double. Box-Cox transformation parameter.}
}
\value{
Returns a single value which is estimated log-likelihood.
}
\description{
Estimated log-likelihood.
}
\examples{
\dontrun{
## load data
data("cardiacsurgery", package = "spcadjust")

## preprocess data to 30 day mortality and subset data to
## phase I (In-control) and phase II (monitoring)
SALL <- cardiacsurgery \%>\% rename(s = Parsonnet) \%>\%
  mutate(y = ifelse(status == 1 & time <= 30, 1, 0),
         phase = factor(ifelse(date < 2*365, "I", "II")))

## subset phase I (In-control)
SI <- filter(SALL, phase == "I") \%>\% select(s, y)

dML <- search_delta(SI$s, SI$y, type = "ML")
ell(SI$s, SI$y, dML)
}
}
\author{
Philipp Wittenberg
}
