% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enbs.R
\name{enbs_opt}
\alias{enbs_opt}
\title{Determine the optimum sample size in an analysis of the expected net benefit
of sampling}
\usage{
enbs_opt(x, pcut = 0.05, smooth = FALSE, smooth_df = NULL, keep_preds = FALSE)
}
\arguments{
\item{x}{Data frame containing a set of ENBS estimates for
different sample sizes, which will be optimised over.  Usually
this is for a common willingness-to-pay. The required components
are \code{enbs} and \code{n}.}

\item{pcut}{Cut-off probability which defines a "near-optimal" sample size.
The minimum and maximum sample size for which the ENBS is within
\code{pcut} (by default 5\%) of its maximum value will be determined.}

\item{smooth}{If \code{TRUE}, then the maximum ENBS is determined after
fitting a nonparametric regression to the data frame \code{x}, which
estimates and smooths the ENBS for every integer sample size in the range
of \code{x$n}.  The regression is done using the default settings of
\code{\link[mgcv]{gam}} from the \pkg{mgcv} package.

If this is \code{FALSE}, then no smoothing or interpolation is done, and
the maximum is determined by searching over the values supplied in
\code{x}.}

\item{smooth_df}{Basis dimension for the smooth regression. Passed as the
\code{k} argument to the \code{s()} term in \code{\link[mgcv]{gam}}.   Defaults to
6, or the number of unique sample sizes minus 1 if this is lower.  Set
to a higher number if you think the smoother does not capture the
relation of ENBS to sample size accurately enough.}

\item{keep_preds}{If \code{TRUE} and \code{smooth=TRUE} then the data frame of
predictions from the smooth regression model is stored in the \code{"preds"}
attribute of the result.}
}
\value{
A data frame with one row, and the following columns:

\code{ind}: An integer index identifying, e.g. the willingness to pay and other common characteristics of the ENBS estimates (e.g. incident population size, decision time horizon). This is copied from \code{x$ind}.

\code{enbsmax}: the maximum ENBS

\code{nmax}: the sample size at which this maximum is achieved

\code{nlower}: the lowest sample size for which the ENBS is within

\code{pcut} (default 5\%) of its maximum value

\code{nupper}: the corresponding highest ENBS
}
\description{
The optimum sample size for a given willingness to pay is determined either
by a simple search over the supplied ENBS estimates for different sample
sizes, or by a regression and interpolation method.
}
