% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evsivar.R
\name{evsivar}
\alias{evsivar}
\title{Calculate the expected value of sample information for an estimation problem}
\usage{
evsivar(
  outputs,
  inputs,
  study = NULL,
  datagen_fn = NULL,
  pars = NULL,
  n = 100,
  aux_pars = NULL,
  method = NULL,
  nsim = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{outputs}{a vector of values for the quantity of interest, sampled from the uncertainty distribution of this quantity that is induced by the uncertainty about the parameters.}

\item{inputs}{Matrix or data frame of samples from the uncertainty
distribution of the input parameters of the decision model.   The number
of columns should equal the number of parameters, and the columns should
be named.    This should have the same number of rows as there are samples
in \code{outputs}, and each row of the samples in \code{outputs} should
give the model output evaluated at the corresponding parameters.

Users of \pkg{heemod} can create an object of this form, given an object
produced by \code{run_psa} (\code{obj}, say), with \code{\link{import_heemod_inputs}}.}

\item{study}{Name of one of the built-in study types supported by this
package for EVSI calculation.  If this is supplied, then the columns of
\code{inputs} that correspond to the parameters governing the study data
should be identified in \code{pars}.

Current built-in studies are

\code{"binary"} A study with a binary outcome observed on one sample of
individuals.   Requires one parameter: the probability of the outcome. The
sample size is specifed in the \code{n} argument to \code{evsi()}, and the
binomially-distributed outcome is named \code{X1}.

\code{"trial_binary"} Two-arm trial with a binary outcome.   Requires two
parameters: the probability of the outcome in arm 1 and 2 respectively.
The sample size is the same in each arm, specifed in the \code{n} argument
to \code{evsi()}, and the binomial outcomes are named \code{X1} and
\code{X2} respectively.

\code{"normal_known"} A study of a normally-distributed outcome, with a
known standard deviation, on one sample of individuals.  Likewise the
sample size is specified in the \code{n} argument to \code{evsi()}.  The
standard deviation defaults to 1, and can be changed by specifying
\code{sd} as a component of the \code{aux_pars} argument, e.g.
\code{evsi(..., aux_pars=list(sd=2))}.

Either \code{study} or \code{datagen_fn} should be supplied to
\code{evsi()}.

For the EVSI calculation methods where explicit Bayesian analyses of the
simulated data are performed, the prior parameters for these built-in studies
are supplied in the \code{analysis_args} argument to \code{evsi()}.  These
assume Beta priors for probabilities, and Normal priors for the mean of a
normal outcome.}

\item{datagen_fn}{If the proposed study is not one of the built-in types
supported, it can be specified in this argument as an R function to sample
predicted data from the study.  This function should have the following
specification:
\enumerate{
\item the function's first argument should be a data frame of parameter
simulations, with one row per simulation and one column per parameter.
The parameters in this data frame must all be found in \code{inputs},
but need not necessarily be in the same order or include all of them.
\item the function should return a data frame.
\item the returned data frame should have number of rows equal to the number
of parameter simulations in \code{inputs}.
\item if \code{inputs} is considered as a sample from the posterior, then
\code{datagen_fn(inputs)} returns a corresponding sample from the
posterior predictive distribution, which includes two sources of
uncertainty: (a) uncertainty about the parameters and (b) sampling
variation in observed data given fixed parameter values.
\item the function can optionally have more than one argument. If so, these
additional arguments should be given default values in the definition of
\code{datagen_fn}.  If there is an argument called \code{n}, then it is
interpreted as the sample size for the proposed study.
}}

\item{pars}{Character vector identifying which parameters are learned from the proposed study.
These should be columns of \code{inputs}.}

\item{n}{Sample size of future study, or vector of alternative sample sizes.
This is understood by the built-in study designs.  For studies specified
by the user with \code{datagen_fn}, if \code{datagen_fn} has an argument
\code{n}, then this is interpreted as the sample size.  However if
calling \code{evsi} for a user-specified design where
\code{datagen_fn} does not have an \code{n} argument, then any \code{n}
argument supplied to \code{evsi} will be ignored.

Currently this
shortcut is not supported if more than one quantity is required to
describe the sample size, for example, trials with unbalanced arms.  In
that case, you will have to hard-code the required sample sizes into
\code{datagen_fn}.

For the nonparametric regression and importance sampling methods, the
computation is simply repeated for each sample size supplied here.

The moment matching method uses a regression model to estimate the
dependency of the EVSI on the sample size, hence to enable EVSI to be
calculated efficiently for any number of sample sizes (Heath et al. 2019).}

\item{aux_pars}{A list of additional fixed arguments to supply to the
function to generate the data, whether that is a built-in study design or user-defined
function supplied in \code{datagen_fn}.  For example, \code{evsi(..., aux_pars = list(sd=2))} defines the fixed
standard deviation in the \code{"normal_known"} model.}

\item{method}{See \code{\link{evsi}}, only nonparametric regression methods are
currently supported in \code{\link{evsivar}}.}

\item{nsim}{Number of simulations from the model to use for calculating
EVPPI.  The first \code{nsim} rows of the objects in \code{inputs} and
\code{outputs} are used.}

\item{verbose}{If \code{TRUE}, then messages are printed
describing each step of the calculation, if the method supplies
these.  Can be useful to see the progress of slow calculations.}

\item{...}{Other arguments understood by specific methods, e.g. \code{gam_formula}
and other controlling options (see \code{\link{evppi}}) can be passed to the
nonparametric regression used inside the moment matching method.}
}
\value{
A data frame with a column \code{pars}, indicating the parameter(s), and a column \code{evsi}, giving the corresponding EVSI.  If there are EVSI estimates for multiple sample sizes, the sample size is returned in the column \code{n}.
}
\description{
Calculate the expected value of sample information for an estimation problem.  This computes the expected reduction in variance in some quantity of interest from a study of a certain design that informs the parameters of interest.
}
\references{
Jackson, C., Presanis, A., Conti, S., & De Angelis, D. (2019). Value of information:
Sensitivity analysis and research design in Bayesian evidence synthesis.
Journal of the American Statistical Association, 114(528), 1436-1449.
}
