% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radial_plotly.R
\name{radial_plotly}
\alias{radial_plotly}
\title{Three-way radial comparison Polar Plot (using plotly)}
\usage{
radial_plotly(
  polar,
  type = 1,
  colours = polar@scheme,
  label_rows = NULL,
  arrow_length = 80,
  label_size = 14,
  colour_code_labels = FALSE,
  label_colour = "black",
  grid_colour = "grey80",
  grid_width = 1,
  marker_size = 7,
  marker_alpha = 0.8,
  marker_outline_colour = "white",
  marker_outline_width = 0.5,
  axis_title_size = 16,
  axis_label_size = 10,
  axis_colour = "black",
  axis_width = 2,
  ...
)
}
\arguments{
\item{polar}{A 'volc3d' object with the p-values between groups of interest
and polar coordinates created by \code{\link{polar_coords}},
\code{\link{deseq_polar}} or \code{\link{voom_polar}}.}

\item{type}{Numeric value whether to use scaled (Z-score) or unscaled (fold
change) as magnitude. Options are 1 = Z-score (default) or 2 =
unscaled/fold change.}

\item{colours}{A vector of colour names or hex triplets for the
non-significant points and each of the six groups.}

\item{label_rows}{A vector of row names or numbers to label.}

\item{arrow_length}{The length of label arrows (default = 80).}

\item{label_size}{Font size of labels/annotations (default = 14)}

\item{colour_code_labels}{Logical whether label annotations should be colour
coded. If FALSE label_colour is used.}

\item{label_colour}{HTML colour of annotation labels if not colour coded.}

\item{grid_colour}{The colour of the grid (default="grey80")}

\item{grid_width}{The width of the grid lines (default=1)}

\item{marker_size}{Size of the markers (default = 6)}

\item{marker_alpha}{Opacity for the markers (default = 0.7)}

\item{marker_outline_colour}{Colour for marker outline (default = white)}

\item{marker_outline_width}{Width for marker outline (default = 0.5)}

\item{axis_title_size}{Font size for axis titles (default = 16)}

\item{axis_label_size}{Font size for axis labels (default = 10)}

\item{axis_colour}{The colour of the grid axes and labels (default="black")}

\item{axis_width}{The width of the axis lines (default=2)}

\item{...}{Optional parameters passed to \code{\link[volcano3D]{polar_grid}}
e.g. \code{r_axis_ticks} or \code{axis_angle}}
}
\value{
Returns a plotly plot featuring variables on a tri-axis radial graph
}
\description{
This function creates an interactive plotly object which maps differential
expression onto a polar coordinates.
}
\details{
This function builds a layered plotly object. By default this produces an SVG
output, but this can be slow with 1000s of points. For large number of points
we recommend switching to webGL by piping to \code{toWebGL()} as shown in the
examples.
}
\examples{
data(example_data)
syn_polar <- polar_coords(outcome = syn_example_meta$Pathotype,
                          data = t(syn_example_rld))

radial_plotly(polar = syn_polar, label_rows = c("COBL"))

## Faster webGL version for large numbers of points
library(plotly)
radial_plotly(polar = syn_polar, label_rows = c("COBL")) \%>\%
  toWebGL()

}
\references{
Lewis, Myles J., et al. (2019).
\href{https://pubmed.ncbi.nlm.nih.gov/31461658/}{
Molecular portraits of early rheumatoid arthritis identify clinical and
treatment response phenotypes.}
\emph{Cell reports}, \strong{28}:9
}
\seealso{
\code{\link{polar_coords}}
}
\keyword{hplot}
\keyword{iplot}
