% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenZonotope.R
\name{GenZonotope}
\alias{GenZonotope}
\title{Generator function for zonotopes}
\usage{
GenZonotope(dimension, NumGen)
}
\arguments{
\item{dimension}{The dimension of the zonotope.}

\item{NumGen}{The number of segments that generate the zonotope.}
}
\value{
A polytope class representing a zonotope.
}
\description{
This function can be used to generate a random \eqn{d}-dimensional zonotope defined by the Minkowski sum of \eqn{m} \eqn{d}-dimensional segments. We consider \eqn{m} random directions in \eqn{R^d} and for each direction we pick a random length in \eqn{[(,\sqrt{d}]} in order to define \eqn{m} segments.
}
\examples{
# generate a 10-dimensional zonotope defined by the Minkowski sum of 20 segments
P = GenZonotope(10, 20)
}
